package jp.co.sra.jun.geometry.forms;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;

/**
 * JunFormTriangulationTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/19 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun666 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormTriangulationTestExamples.java,v 8.6 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormTriangulationTestExamples extends JunForm2dRegionTestExamples {
	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormTriangulation formTriangulation = new JunFormTriangulation(polylines[index]);
			Point extentPoint = formTriangulation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formTriangulation.triangles();
				formTriangulation.displayOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);
			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			Class[] triangulationClasses = new Class[] { JunFormTriangulation1.class, JunFormTriangulation2.class, JunFormTriangulation3.class };
			for (int i = 0; i < triangulationClasses.length; i++) {
				final JunFormTriangulation formTriangulation = new JunFormTriangulation(polylines[index], triangulationClasses[i]);
				double areaOfTriangles = formTriangulation.area();
				double areaWithSignOfTriangles = formTriangulation.areaWithSign();

				System.out.println(triangulationClasses[i].getName());
				System.out.println("\t total area of triangles: " + areaOfTriangles);
				System.out.println("\t total area of triangles with sign: " + areaWithSignOfTriangles);
			}
			System.out.println();
		}

		return true;
	}

	/**
	 * Answer the example polylines.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[][] ExamplePolylines() {
		Jun2dPoint[][] examplePolylines = ExampleOriginalPolylines();
		return new Jun2dPoint[][] { examplePolylines[3], examplePolylines[9] };
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunFormTriangulationTestExamples();
	}
}
