package jp.co.sra.jun.geometry.pluralities;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingObject;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;

/**
 * Jun2dBoundingBalls class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dBoundingBalls.java,v 8.8 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun2dBoundingBalls extends JunBoundingBalls {
	/**
	 * Create a new instance of <code>Jun2dBoundingBalls</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun2dBoundingBalls() {
		super();
	}

	/**
	 * Answer my current bounding ball.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall
	 * @category accessing
	 */
	public Jun2dBoundingBall boundingBall() {
		if (this.isEmpty()) {
			return new Jun2dBoundingBall(null);
		}
		Jun2dBoundingBall boundingBall = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun2dBoundingBox each = (Jun2dBoundingBox) objects[i];
			if (boundingBall == null) {
				boundingBall = each.boundingBall();
			} else {
				boundingBall = each.boundingBall().merge_(boundingBall);
			}
		}
		return boundingBall;
	}

	/**
	 * Answer my bounding balls.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall[]
	 * @category accessing
	 */
	public Jun2dBoundingBall[] boundingBalls() {
		return (Jun2dBoundingBall[]) this._boundingObjects().toArray(new Jun2dBoundingBall[this._boundingObjects().size()]);
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox
	 * @category accessing
	 */
	public Jun2dBoundingBox boundingBox() {
		if (this.isEmpty()) {
			return new Jun2dBoundingBox();
		}
		Jun2dBoundingBox boundingBox = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun2dBoundingBall each = (Jun2dBoundingBall) objects[i];
			if (boundingBox == null) {
				boundingBox = each.boundingBox();
			} else {
				boundingBox = each.boundingBox().merge_(boundingBox);
			}
		}
		return boundingBox;
	}

	/**
	 * Convert to a <code>Jun2dBoundingBall</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall
	 * @category converting
	 */
	public Jun2dBoundingBall asBoundingBall() {
		return this.boundingBall();
	}

	/**
	 * Convert to a <code>Jun2dBoundingBox</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox
	 * @category converting
	 */
	public Jun2dBoundingBox asBoundingBox() {
		return this.boundingBox();
	}

	/**
	 * Answer <code>true</code> if the receiver is a 2d geometry element.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#is2d()
	 * @category testing
	 */
	public boolean is2d() {
		return true;
	}

	/**
	 * Answer <code>true</code> if the receiver touches the specified bounding object, otherwise <code>false</code>.
	 * 
	 * @param aBoundingObject jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall
	 * @return boolean
	 * @category testing
	 */
	public boolean touches_(final Jun2dBoundingBall aBoundingObject) {
		return this.detect_ifNone_(new StBlockClosure() {
			public Object value(Object each) {
				return new Boolean(((Jun2dBoundingBall) each).touches_(aBoundingObject));
			}
		}, new StBlockClosure() {
			public Object value(Object each) {
				return null;
			}
		}) != null;
	}

	/**
	 * Apply a transformation 'aTransformation' to the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBalls
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun2dTransformation
	 * @category transforming
	 */
	public Jun2dBoundingBalls transform_(Jun2dTransformation aTransformation) {
		Jun2dBoundingBalls transformedCopy = new Jun2dBoundingBalls();
		JunBoundingObject[] boundingBalls = this.boundingBalls();
		for (int i = 0; i < boundingBalls.length; i++) {
			this.add_(boundingBalls[i].transform_(aTransformation));
		}
		return transformedCopy;
	}
}
