package jp.co.sra.jun.geometry.pluralities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun2dBoundingBoxesTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/04/24 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dBoundingBoxesTestExamples.java,v 8.12 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun2dBoundingBoxesTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun2dBoundingBoxes boundingBoxes = new Jun2dBoundingBoxes();
		boundingBoxes.add_(Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(51, 33), new Jun2dPoint(195, 147)));
		boundingBoxes.add_(Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(93, 45), new Jun2dPoint(237, 159)));
		boundingBoxes.add_(Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(129, 69), new Jun2dPoint(273, 183)));
		boundingBoxes.add_(Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(81, 111), new Jun2dPoint(225, 225)));

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(boundingBoxes.asJunOpenGL3dObjectColor_alpha_(Color.cyan, 0.5f));
		compoundObject.add_(boundingBoxes.intersectionBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 200)));
		compoundObject.add_(boundingBoxes.unionBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 400)));
		compoundObject.add_(boundingBoxes.complementBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 600)));
		compoundObject.add_(boundingBoxes.differenceBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 800)));

		compoundObject.showIn_(new Rectangle(200, 200, 280, 500));

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Point[] pointCollection = ExamplePoints();
		Jun2dBoundingBoxes boundingBoxes = Jun2dBoundingBoxes.FromPolyline_bitSize_(pointCollection, new Dimension(16, 16));
		Jun2dPoint centerPoint = boundingBoxes.boundingBox().center();

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] vertexes = new Jun3dPoint[pointCollection.length];
		for (int i = 0; i < pointCollection.length; i++) {
			vertexes[i] = new Jun3dPoint(pointCollection[i].x, pointCollection[i].y, 0);
		}
		compoundObject.add_(new JunOpenGL3dPolyline(vertexes, Color.red));
		compoundObject.add_(boundingBoxes.asJunOpenGL3dObjectColor_alpha_(Color.orange, 0.5f));

		compoundObject.showEyePoint_sightPoint_upVector_(new Jun3dPoint(centerPoint.x(), centerPoint.y(), 10000), centerPoint.as3dPoint(), new Jun3dPoint(0, 1, 0));
		return true;
	}

	/**
	 * Example: for subdivide.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _ExampleSubdivide() {
		new Jun2dPoint(0, 0).box_(new Jun2dPoint(1, 1)).asBoundingBoxes().subdivide().showWithUnitArrows().wireframePresentation();

		return true;
	}

	/**
	 * Answer the example points.
	 * 
	 * @return java.awt.Point[]
	 * @category Examples
	 */
	protected static Point[] ExamplePoints() {
		ArrayList aList = new ArrayList();
		aList.add(new Point(272, 175));
		aList.add(new Point(281, 179));
		aList.add(new Point(293, 183));
		aList.add(new Point(302, 183));
		aList.add(new Point(314, 187));
		aList.add(new Point(328, 191));
		aList.add(new Point(342, 196));
		aList.add(new Point(352, 200));
		aList.add(new Point(362, 204));
		aList.add(new Point(373, 211));
		aList.add(new Point(383, 219));
		aList.add(new Point(389, 227));
		aList.add(new Point(392, 238));
		aList.add(new Point(396, 251));
		aList.add(new Point(396, 265));
		aList.add(new Point(394, 277));
		aList.add(new Point(388, 293));
		aList.add(new Point(383, 305));
		aList.add(new Point(374, 315));
		aList.add(new Point(362, 320));
		aList.add(new Point(348, 323));
		aList.add(new Point(337, 321));
		aList.add(new Point(325, 315));
		aList.add(new Point(320, 305));
		aList.add(new Point(319, 290));
		aList.add(new Point(321, 276));
		aList.add(new Point(326, 263));
		aList.add(new Point(332, 253));
		aList.add(new Point(340, 247));
		aList.add(new Point(351, 240));
		aList.add(new Point(364, 232));
		aList.add(new Point(377, 228));
		aList.add(new Point(386, 222));
		aList.add(new Point(397, 215));
		aList.add(new Point(404, 209));
		aList.add(new Point(411, 200));
		aList.add(new Point(414, 193));
		aList.add(new Point(416, 187));
		aList.add(new Point(417, 178));
		aList.add(new Point(417, 171));
		aList.add(new Point(417, 162));
		aList.add(new Point(417, 154));
		aList.add(new Point(414, 147));
		aList.add(new Point(412, 144));
		aList.add(new Point(410, 140));
		aList.add(new Point(406, 137));
		aList.add(new Point(401, 134));
		aList.add(new Point(397, 131));
		aList.add(new Point(390, 130));
		aList.add(new Point(383, 132));
		aList.add(new Point(374, 135));
		aList.add(new Point(367, 140));
		aList.add(new Point(360, 145));
		aList.add(new Point(352, 155));
		aList.add(new Point(347, 163));
		aList.add(new Point(341, 171));
		aList.add(new Point(337, 181));
		aList.add(new Point(332, 195));
		aList.add(new Point(327, 205));
		aList.add(new Point(320, 215));
		aList.add(new Point(312, 228));
		aList.add(new Point(301, 242));
		aList.add(new Point(291, 248));
		aList.add(new Point(282, 251));
		aList.add(new Point(269, 254));
		aList.add(new Point(262, 253));
		aList.add(new Point(253, 250));
		aList.add(new Point(246, 243));
		aList.add(new Point(238, 236));
		aList.add(new Point(235, 228));
		aList.add(new Point(233, 219));
		aList.add(new Point(231, 209));
		aList.add(new Point(232, 201));
		aList.add(new Point(233, 196));
		aList.add(new Point(239, 188));
		aList.add(new Point(243, 182));
		aList.add(new Point(245, 178));
		aList.add(new Point(247, 176));
		aList.add(new Point(249, 174));
		aList.add(new Point(250, 174));
		aList.add(new Point(252, 173));
		return (Point[]) aList.toArray(new Point[aList.size()]);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun2dBoundingBoxesTestExamples();
	}
}
