package jp.co.sra.jun.geometry.pluralities;

import java.util.Collection;
import java.util.List;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.boundaries.JunBoundingObject;

/**
 * JunBoundingObjects class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/10/19 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingObjects.java,v 8.14 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunBoundingObjects extends JunGeometries {
	/**
	 * Create a new instance of <code>JunBoundingObjects</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunBoundingObjects() {
		super();
	}

	/**
	 * Create a new instance of JunGeometry and initialize it.
	 * 
	 * @param sizeInteger int
	 * @category Instance creation
	 */
	public JunBoundingObjects(int sizeInteger) {
		super();
	}

	/**
	 * Answer the bounding objects.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.JunBoundingObject[]
	 * @category accessing
	 */
	public JunBoundingObject[] boundingObjects() {
		return (JunBoundingObject[]) this._geometries().toArray(new JunBoundingObject[this.size()]);
	}

	/**
	 * Answer the bounding objects.
	 * 
	 * @return java.util.List
	 * @category accessing
	 */
	protected List _boundingObjects() {
		return this._geometries();
	}

	/**
	 * Set the bounding objects.
	 * 
	 * @param boundingObjectCollection java.util.Collection
	 * @category accessing
	 */
	public void boundingObjects_(Collection boundingObjectCollection) {
		this.geometries_(boundingObjectCollection);
	}

	/**
	 * Answer the size of bounding objects.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.geometry.pluralities.JunGeometries#size()
	 * @category accessing
	 */
	public int size() {
		return this._boundingObjects().size();
	}

	/**
	 * Add all of the bounding objects.
	 * 
	 * @param boundingObjects jp.co.sra.jun.geometry.pluralities.JunBoundingObjects
	 * @category adding
	 */
	public void addAll_(JunBoundingObjects boundingObjects) {
		if (boundingObjects == null) {
			return;
		}
		JunBoundingObject[] objects = boundingObjects.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			this.add_(objects[i]);
		}
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.pluralities.JunGeometries#isEmpty()
	 * @category testing
	 */
	public boolean isEmpty() {
		return (this.size() < 1 || (this.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object boundingBox) {
				if (((JunBoundingObject) boundingBox).isEmpty() == false) {
					return Boolean.TRUE;
				}
				return null;
			}
		}, new StBlockClosure() {
			public Object value() {
				return null;
			}
		}) == null));
	}

	/**
	 * Answer true if the receiver is a bounding objects, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isBoundingObjects()
	 * @category testing
	 */
	public boolean isBoundingObjects() {
		return true;
	}
}
