package jp.co.sra.jun.geometry.pluralities;

import java.util.Collection;

import jp.co.sra.jun.geometry.surfaces.JunTriangle;

/**
 * JunTriangles class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTriangles.java,v 8.5 2008/02/20 06:30:58 nisinaka Exp $
 */
public abstract class JunTriangles extends JunGeometries {
	/**
	 * Create a new instance of <code>JunTriangles</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunTriangles() {
		super();
	}

	/**
	 * Create a new instance of <code>JunTriangles</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunTriangles(Collection triangleCollection) {
		super();
		this.triangles_(triangleCollection);
	}

	/**
	 * Create a new instance of <code>JunTriangles</code> and initialize it.
	 * 
	 * @param triangleCollection jp.co.sra.jun.geometry.surfaces.JunTriangle[]
	 * @category Instance creation
	 */
	public JunTriangles(JunTriangle[] triangleCollection) {
		super();
		this.triangles_(triangleCollection);
	}

	/**
	 * Set the receiver's triangles.
	 * 
	 * @param triangleCollection java.util.Collection
	 * @category accessing
	 */
	public void triangles_(Collection triangleCollection) {
		this.geometries_(triangleCollection);
	}

	/**
	 * Set the receiver's triangles.
	 * 
	 * @param triangleCollection jp.co.sra.jun.geometry.surfaces.JunTriangle[]
	 * @category accessing
	 */
	public void triangles_(JunTriangle[] triangleCollection) {
		this.geometries_(triangleCollection);
	}

	/**
	 * Answer true if the receiver is a triangles, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isTriangles()
	 * @category testing
	 */
	public boolean isTriangles() {
		return true;
	}
}
