package jp.co.sra.jun.geometry.solid;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunTetrahedronTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/07/02 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun607 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTetrahedronTestExamples.java,v 8.5 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunTetrahedronTestExamples extends JunTestExamples {
	/**
	 * Example1: Show a tetrahedron as JunOpenGL3dObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunTetrahedron aTetrahedron = new JunTetrahedron(new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1), new Jun3dPoint(0, 0, 0));
		System.out.println(aTetrahedron.printString());
		System.out.println(aTetrahedron.storeString());
		System.out.println("area: " + aTetrahedron.area());
		System.out.println("volume:" + aTetrahedron.volume());
		aTetrahedron.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunTetrahedronTestExamples();
	}
}
