package jp.co.sra.jun.geometry.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunPointsOnPlaneTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/10/24 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun629 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPointsOnPlaneTestExamples.java,v 8.10 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunPointsOnPlaneTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunPointsOnPlane pointsOnPlane = new JunPointsOnPlane(Example1Points());
		pointsOnPlane.show();

		return true;
	}

	/**
	 * Create an array of points for Example1.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] Example1Points() {
		List aList = new ArrayList();

		Jun3dLine[] lines = new Jun3dLine[4];
		lines[0] = new Jun3dLine(new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0));
		lines[1] = new Jun3dLine(new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0));
		lines[2] = new Jun3dLine(new Jun3dPoint(-1, -1, 0), new Jun3dPoint(1, -1, 0));
		lines[3] = new Jun3dLine(new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0));
		double[] parameters = new double[] { 0, 0.3, 0.4, 0.6, 0.9, 1 };
		for (int i = 0; i < lines.length; i++) {
			for (int j = 0; j < parameters.length; j++) {
				aList.add(lines[i].atT_(parameters[j]));
			}
		}

		JunAngle anAngle = JunAngle.FromRad_(Math.PI * Math.random());
		Jun3dPoint aDelta = new Jun3dPoint(Math.random(), Math.random(), Math.random());
		Jun3dPoint[] points = (Jun3dPoint[]) aList.toArray(new Jun3dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			points[i] = points[i].rotatedBy_(anAngle).translatedBy_(aDelta);
		}

		Collections.shuffle(Arrays.asList(points));
		return points;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunPointsOnPlane pointsOnPlane = new JunPointsOnPlane(Example2Points());
		pointsOnPlane.show();

		return true;
	}

	/**
	 * Create an array of points for Example2.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] Example2Points() {
		List aList = new ArrayList();

		Jun3dLine[] lines = new Jun3dLine[4];
		lines[0] = new Jun3dLine(new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0));
		lines[1] = new Jun3dLine(new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0));
		lines[2] = new Jun3dLine(new Jun3dPoint(-1, -1, 0), new Jun3dPoint(1, -1, 0));
		lines[3] = new Jun3dLine(new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0));
		for (int i = 0; i < lines.length; i++) {
			for (int j = 0; j < 5; j++) {
				aList.add(lines[i].atT_(Math.random()));
			}
		}

		JunAngle anAngle = JunAngle.FromRad_(Math.PI * Math.random());
		Jun3dPoint aDelta = new Jun3dPoint(Math.random(), Math.random(), Math.random());
		Jun3dPoint[] points = (Jun3dPoint[]) aList.toArray(new Jun3dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			points[i] = points[i].rotatedBy_(anAngle).translatedBy_(aDelta);
		}

		Collections.shuffle(Arrays.asList(points));
		return points;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunPointsOnPlane pointsOnPlane = new JunPointsOnPlane(Example3Points());
		pointsOnPlane.show();

		return true;
	}

	/**
	 * Create an array of points for Example3.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] Example3Points() {
		List aList = new ArrayList();

		for (int degree = 0; degree <= 360; degree += 10) {
			Jun3dPoint aPoint = new Jun3dPoint(Math.random() + 0.5, 0, 0);
			aPoint = aPoint.rotatedBy_(JunAngle.FromDeg_(degree));
			aList.add(aPoint);
		}

		JunAngle anAngle = JunAngle.FromRad_(Math.PI * Math.random());
		Jun3dPoint aDelta = new Jun3dPoint(Math.random(), Math.random(), Math.random());
		Jun3dPoint[] points = (Jun3dPoint[]) aList.toArray(new Jun3dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			points[i] = points[i].rotatedBy_(anAngle).translatedBy_(aDelta);
		}

		Collections.shuffle(Arrays.asList(points));
		return points;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunPointsOnPlaneTestExamples();
	}

}
