package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun2dTriangleTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/12/21 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dTriangleTestExamples.java,v 8.10 2008/02/20 06:30:58 nisinaka Exp $
 */
public class Jun2dTriangleTestExamples extends JunTestExamples {
	/**
	 * Example1.
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Example1() {
		Jun2dTriangle aTriangle = Jun2dTriangle.On_on_on_(new Jun2dPoint(1, 0), new Jun2dPoint(0, 1), new Jun2dPoint(0, 0));
		System.out.println(aTriangle.printString());
		System.out.println(aTriangle.storeString());
		System.out.println("area:" + aTriangle.area());
		System.out.println("volume:" + aTriangle.volume());
		aTriangle.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun2dTriangleTestExamples();
	}
}
