package jp.co.sra.jun.goodies.bulletinboard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StDisplayable;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunBulletinElement class
 * 
 *  @author    nisinaka
 *  @created   2002/11/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBulletinElement.java,v 8.13 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunBulletinElement extends JunAbstractObject {
	protected StDisplayable visualEntity;
	protected Rectangle visualRectangle;
	protected Color visualColor;

	/**
	 * Create a new instance of <code>JunBulletinElement</code> and initialize it with the specified entity object.
	 * 
	 * @param anEntityObject java.lang.Object
	 * @category Instance creation
	 */
	public JunBulletinElement(Object anEntityObject) {
		this();
		this.entity_(anEntityObject);
	}

	/**
	 * Create a new instance of <code>JunBulletinElement</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	protected JunBulletinElement() {
		super();
	}

	/**
	 * Answer the color of the receiver.
	 *
	 * @return java.awt.Color
	 * @category accessing
	 */
	public Color color() {
		return visualColor;
	}

	/**
	 * Set the new color of the receiver.
	 *
	 * @param newColor java.awt.Color
	 * @category accessing
	 */
	public void color_(Color newColor) {
		visualColor = newColor;
	}

	/**
	 * Answer the entity of the reciever.
	 *
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable entity() {
		return visualEntity;
	}

	/**
	 * Set the specified object as an entity of the receiver.
	 *
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void entity_(Object anObject) {
		if (anObject instanceof StDisplayable) {
			visualEntity = (StDisplayable) anObject;
		} else {
			String aString;
			if (anObject instanceof String) {
				aString = JunBulletinBoard.ConvertToFlatString_((String) anObject);
			} else {
				aString = JunBulletinBoard.ConvertToFlatString_(anObject.toString());
			}
			StComposedText composedText = new StComposedText(aString, this.font());
			visualEntity = composedText;
		}
		this.rectangle_(visualEntity.bounds());
	}

	/**
	 * Answer the font of the receiver.
	 *
	 * @return java.awt.Font
	 * @category accessing
	 */
	public Font font() {
		if (this.entity() instanceof StComposedText) {
			return ((StComposedText) this.entity()).font();
		}

		return JunBulletinBoard.Font();
	}

	/**
	 * Set the new font of the receiver.
	 * Replacement of the style: method with a TextAttribute in Smalltalk version.
	 *
	 * @param newFont java.awt.Font
	 * @category accessing
	 */
	public void font_(Font newFont) {
		if (this.entity() instanceof StComposedText) {
			StComposedText composedText = new StComposedText(((StComposedText) this.entity()).string(), newFont);
			visualEntity = composedText;
			this.rectangle_(visualEntity.bounds());
		}
	}

	/**
	 * Answer the height of the receiver.
	 *
	 * @return int
	 * @category accessing
	 */
	public int height() {
		return this.rectangle().height;
	}

	/**
	 * Answer the bounds of the receiver.
	 *
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public Rectangle rectangle() {
		return visualRectangle;
	}

	/**
	 * Set the new bounds of the receiver.
	 *
	 * @param newRectangle java.awt.Rectangle
	 * @category accessing
	 */
	public void rectangle_(Rectangle newRectangle) {
		visualRectangle = newRectangle;
	}

	/**
	 * Answer the width of the receiver.
	 *
	 * @return int
	 * @category accessing
	 */
	public int width() {
		return this.rectangle().width;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		visualEntity = null;
		visualRectangle = new Rectangle(0, 0, 0, 0);
		visualColor = Color.black;
	}
}
