package jp.co.sra.jun.goodies.button;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.cursors.JunCursors;

/**
 * JunButtonModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/xx (by nisinaka)
 *  @updated   2002/11/03 (by nisinaka)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonModelTestExamples.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: the button label is a String.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunButtonModel buttonModel = new JunButtonModel(false, "test", new StBlockClosure() {
			public Object value_(Object o) {
				JunButtonModel model = (JunButtonModel) o;
				model.value_(!model.value());
				return model;
			}
		});
		buttonModel.open();
		return true;
	}

	/**
	 * Example2: the button label is an image.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunButtonModel buttonModel = new JunButtonModel(true, JunCursors.ExecuteCursorImage(), new StBlockClosure() {
			public Object value_(Object o) {
				JunButtonModel model = (JunButtonModel) o;
				model.value_(!model.value());
				return model;
			}
		});
		buttonModel.open();
		return true;
	}

	/**
	 * Example3: the button label is an image.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunButtonModel buttonModel = new JunButtonModel(false, StImage._FromUser(), new StBlockClosure() {
			public Object value_(Object o) {
				JunButtonModel model = (JunButtonModel) o;
				model.value_(!model.value());
				return model;
			}
		});
		buttonModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunButtonModelTestExamples();
	}

}
