package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;

import jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunCalendarClockDateTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockDateTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockDateTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunCalendarDate.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarClockDate calendarClock = new JunCalendarClockDate();
		calendarClock.open();
		return true;
	}

	/**
	 * Example2: time stamp output for 10 seconds.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarClockDate calendarClock = new JunCalendarClockDate();
		calendarClock.compute_(new StBlockClosure() {
			public Object value_(Object o) {
				Calendar cal = (Calendar) o;
				int year = cal.get(Calendar.YEAR);
				int month = cal.get(Calendar.MONTH);
				int day = cal.get(Calendar.DATE);
				int hour = cal.get(Calendar.HOUR);
				int minute = cal.get(Calendar.MINUTE);
				int second = cal.get(Calendar.SECOND);
				int[] ampm = { 0, 12 };
				hour += ampm[cal.get(Calendar.AM_PM)];
				System.out.println((month + 1) + " " + day + "," + year + " " + hour + ":" + minute + ":" + second);
				return null;
			}
		});
		long endTime = calendarClock.nextMillisecondClockValue() + 10000;
		JunMillisecondModel time = new JunMillisecondModel();
		time.nowValue();
		while (time.milliseconds() < endTime) {
			time.nowValue();
		}
		calendarClock.release();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 */
	public static void main(String args[]) {
		new JunCalendarClockDateTestExamples();
	}
}
