package jp.co.sra.jun.goodies.calendar;

import java.awt.Dimension;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunCalendarClockDateViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockDateViewSwing.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockDateViewSwing extends JunAbstractViewJPanel implements JunCalendarClockDateView {

	protected JunCalendarDateViewSwing dateView;

	/**
	 * Create a new instance of <code>JunCalendarClockDateViewSwing</code> and initialize it.
	 * 
	 * @param aCalendarClockDate JunCalendarClockDate
	 * @category Instance creation
	 */
	public JunCalendarClockDateViewSwing(JunCalendarClockDate aCalendarClockDate) {
		super(aCalendarClockDate);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category defaults
	 */
	public JunCalendarDateViewSwing dateView() {
		if (dateView == null) {
			dateView = new JunCalendarDateViewSwing(this.getModel().calendarDateModel());
		}
		return dateView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessomg
	 */
	public JunCalendarClockDate getModel() {
		return (JunCalendarClockDate) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.dateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(300, 200));
	}

}
