package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.util.Calendar;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunCalendarDateAndTimeIntervalDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalDialog.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalDialog extends StSimpleDialog {
	protected JunCalendarDateAndTimeIntervalModel calendarDateAndTimeIntervalModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeIntervalDialog</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeIntervalDialog() {
		super();
	}

	/**
	 * JunCalendarDateAndTimeIntervalDialog.Request()
	 * 
	 * @return JunCalendarDateAndTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel[] Request() {
		return JunCalendarDateAndTimeIntervalDialog.Request_(null);
	}

	/**
	 * JunCalendarDateAndTimeIntervalDialog.Request_("Select date.")
	 * 
	 * @param messageString java.lang.String
	 * @return JunCalendarDateAndTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel[] Request_(String messageString) {
		Calendar[][] dateArray = { { Calendar.getInstance(), Calendar.getInstance() }, { Calendar.getInstance(), Calendar.getInstance() } };
		return JunCalendarDateAndTimeIntervalDialog.Request_initialDatesAndTimes_(messageString, dateArray);
	}

	/**
	 * JunCalendarDateAndTimeIntervalDialog.Request_initialDate_("Select date.", Calendar.getInstance());
	 * 
	 * @param messageString java.lang.String
	 * @param dateArray java.util.Calendar[][]
	 * @return JunCalendarDateAndTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel[] Request_initialDatesAndTimes_(String messageString, Calendar[][] dateArray) {
		return JunCalendarDateAndTimeIntervalDialog.Request_initialDatesAndTimes_onAccept_onCancel_(messageString, dateArray, null, null);
	}

	/**
	 * JunCalendarDateAndTimeIntervalDialog.Request_initialDate_onAccept_onCancel_(
	 * 	"Select date.",
	 *	Calendar.getInstance(),
	 *	null,
	 *	null)
	 *
	 * @param messageString java.lang.String
	 * @param dateArray java.util.Calendar[][]
	 * @param anAcceptBlock StBlockClosure
	 * @param aCancelBlock StBlockClosure
	 * @return JunCalendarDateAndTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel[] Request_initialDatesAndTimes_onAccept_onCancel_(String messageString, Calendar[][] dateArray, StBlockClosure anAcceptBlock, StBlockClosure aCancelBlock) {
		JunCalendarDateAndTimeIntervalDialog calendarDateAndTimeIntervalDialog = new JunCalendarDateAndTimeIntervalDialog();
		if (!(dateArray == null)) {
			if (dateArray.length > 1) {
				calendarDateAndTimeIntervalDialog.calendarDateAndTimeIntervalModel_(JunCalendarDateAndTimeIntervalModel.From_to_(dateArray[0], dateArray[dateArray.length - 1]));
			}
		}
		Dialog dialog = calendarDateAndTimeIntervalDialog.allButOpenDialog();
		if (!(messageString == null)) {
			dialog.setTitle(messageString);
		}
		if (!(anAcceptBlock == null)) {
			calendarDateAndTimeIntervalDialog.acceptBlock_(anAcceptBlock);
		}
		if (!(aCancelBlock == null)) {
			calendarDateAndTimeIntervalDialog.cancelBlock_(aCancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (calendarDateAndTimeIntervalDialog.accept()._booleanValue()) {
			return calendarDateAndTimeIntervalDialog.calendarDateAndTimeIntervalModel().dateAndTimes();
		} else {
			return null;
		}
	}

	/**
	 * Set an action accept to a block..
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Return a JunCalendarDateAndTimeIntervalModel instance.
	 * @return JunCalendarDateAndTimeIntervalModel
	 * @category accessing
	 */
	public JunCalendarDateAndTimeIntervalModel calendarDateAndTimeIntervalModel() {
		if (calendarDateAndTimeIntervalModel == null) {
			calendarDateAndTimeIntervalModel = new JunCalendarDateAndTimeIntervalModel();
		}
		return calendarDateAndTimeIntervalModel;
	}

	/**
	 * Set new insntace of JunCalendarDateAndTimeIntervalModel.
	 * @param aCalendarDateAndTimeIntervalModel JunCalendarDateAndTimeIntervalModel
	 * @category accessing
	 */
	public void calendarDateAndTimeIntervalModel_(JunCalendarDateAndTimeIntervalModel aCalendarDateAndTimeIntervalModel) {
		calendarDateAndTimeIntervalModel = aCalendarDateAndTimeIntervalModel;
	}

	/**
	 * Set a calcel action to a block.
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Return result of accept button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object acceptButtonPressed() {
		if (!(acceptBlock == null)) {
			return acceptBlock.value_(this.calendarDateAndTimeIntervalModel());
		}
		return new Boolean(true);
	}

	/**
	 * Return result of cancel button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object cancelButtonPressed() {
		if (!(cancelBlock == null)) {
			return cancelBlock.value_(this.calendarDateAndTimeIntervalModel());
		}
		return new Boolean(true);
	}

	/**
	 * Answer a default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunCalendarDateAndTimeIntervalDialogViewAwt(this);
		} else {
			return new JunCalendarDateAndTimeIntervalDialogViewSwing(this);
		}
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Period (Date and Time) Dialog");
	}
}
