package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateAndTimeIntervalModelTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalModelTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunCalendarDateAndTimeIntervalModel.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateAndTimeIntervalModel calendarDateAndTimeIntervalModel = new JunCalendarDateAndTimeIntervalModel();
		calendarDateAndTimeIntervalModel.open();
		return true;
	}

	/**
	 * Example2: Set time and open a JunCalendarDateAndTimeIntervalModel.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		Calendar[] now = { Calendar.getInstance(), Calendar.getInstance() };
		Calendar[] after = { Calendar.getInstance(), Calendar.getInstance() };
		after[0].add(Calendar.DATE, 7);
		after[1].add(Calendar.SECOND, 60);
		JunCalendarDateAndTimeIntervalModel calendarDateAndTimeIntervalModel = JunCalendarDateAndTimeIntervalModel.From_to_(now, after);
		System.out.println(calendarDateAndTimeIntervalModel);
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 */
	public static void main(String args[]) {
		new JunCalendarDateAndTimeIntervalModelTestExamples();
	}
}
