package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunCalendarDateAndTimeIntervalViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalViewAwt.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalViewAwt extends JunAbstractViewPanel implements JunCalendarDateAndTimeIntervalView {

	protected JunCalendarDateViewAwt fromDateView;
	protected JunCalendarTimeViewAwt fromTimeView;
	protected JunCalendarDateViewAwt toDateView;
	protected JunCalendarTimeViewAwt toTimeView;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeIntervalViewAwt</code> and initialize it.
	 * 
	 * @param aCalendarDateAndTimeIntervalModel JunCalendarDateAndTimeIntervalModel
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeIntervalViewAwt(JunCalendarDateAndTimeIntervalModel aCalendarDateAndTimeIntervalModel) {
		super(aCalendarDateAndTimeIntervalModel);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewAwt
	 * @category accessing
	 */
	public JunCalendarDateViewAwt fromDateView() {
		if (fromDateView == null) {
			fromDateView = new JunCalendarDateViewAwt(this.getModel().fromCalendarDateAndTimeModel().calendarDateModel());
		}
		return fromDateView;
	}

	/**
	 * Answer my time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	public JunCalendarTimeViewAwt fromTimeView() {
		if (fromTimeView == null) {
			fromTimeView = new JunCalendarTimeViewAwt(this.getModel().fromCalendarDateAndTimeModel().calendarTimeModel());
		}
		return fromTimeView;
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewAwt
	 * @category accessing
	 */
	public JunCalendarDateViewAwt toDateView() {
		if (toDateView == null) {
			toDateView = new JunCalendarDateViewAwt(this.getModel().toCalendarDateAndTimeModel().calendarDateModel());
		}
		return toDateView;
	}

	/**
	 * Answer my time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	public JunCalendarTimeViewAwt toTimeView() {
		if (toTimeView == null) {
			toTimeView = new JunCalendarTimeViewAwt(this.getModel().toCalendarDateAndTimeModel().calendarTimeModel());
		}
		return toTimeView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarDateAndTimeModel
	 * @category accessing
	 */
	public JunCalendarDateAndTimeIntervalModel getModel() {
		return (JunCalendarDateAndTimeIntervalModel) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromDateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0.67f, 0, 0.5f, 0));
		this.add(this.fromTimeView(), WindowSpecLayout.Position(0.67f, 0, 0f, 1, 1f, -1, 0.5f, 0));
		this.add(this.toDateView(), WindowSpecLayout.Position(0f, 1, 0.5f, 0, 0.67f, 0, 1f, -1));
		this.add(this.toTimeView(), WindowSpecLayout.Position(0.67f, 0, 0.5f, 0, 1f, -1, 1f, -1));
		this.setSize(450, 400);
	}

}
