package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

/**
 * JunCalendarDateIntervalModel class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateIntervalModel.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateIntervalModel extends JunCalendarModel {
	protected JunCalendarDateModel fromCalendarDateModel;
	protected JunCalendarDateModel toCalendarDateModel;

	/**
	 * Create instance and set date from fromDate to toDate.
	 *
	 * @param fromDate java.util.Calendar
	 * @param toDate java.util.Calendar
	 * @return jp.co.sra.jun.goodies.calendar.JunCalendarDateIntervalModel
	 * @category Instance creation
	 */
	public static JunCalendarDateIntervalModel From_to_(Calendar fromDate, Calendar toDate) {
		JunCalendarDateIntervalModel calendarDateIntervalModel = new JunCalendarDateIntervalModel();
		calendarDateIntervalModel.fromCalendarDateModel().date_(fromDate);
		calendarDateIntervalModel.toCalendarDateModel().date_(toDate);
		return calendarDateIntervalModel;
	}

	/**
	 * Answer fromCalendarDateModel.
	 *
	 * @return JunCalendarDateModel
	 * @category Instance creation
	 */
	public JunCalendarDateModel fromCalendarDateModel() {
		if (fromCalendarDateModel == null) {
			fromCalendarDateModel = new JunCalendarDateModel();
			final JunCalendarDateIntervalModel this_ = this;
			fromCalendarDateModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldDate, Object newDate) {
					return (Object) this_.validateFromDate_with_((Calendar) oldDate, (Calendar) newDate);
				}
			});
		}
		return fromCalendarDateModel;
	}

	/**
	 * Answer fromCaalendarDateModel and toCalendarDateModel.
	 *
	 * @return JunCalendarDateModel[]
	 * @category accessing
	 */
	public JunCalendarDateModel[] dates() {
		JunCalendarDateModel[] array = new JunCalendarDateModel[2];
		array[0] = this.fromCalendarDateModel();
		array[1] = this.toCalendarDateModel();
		return array;
	}

	/**
	 * Answer toCalendarDateModel.
	 *
	 * @return JunCalendarDateModel
	 * @category accessing
	 */
	public JunCalendarDateModel toCalendarDateModel() {
		if (toCalendarDateModel == null) {
			toCalendarDateModel = new JunCalendarDateModel();
			final JunCalendarDateIntervalModel this_ = this;
			toCalendarDateModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldDate, Object newDate) {
					return (Object) this_.validateToDate_with_((Calendar) oldDate, (Calendar) newDate);
				}
			});
		}
		return toCalendarDateModel;
	}

	/**
	 * Default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarDateIntervalView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarDateIntervalViewAwt(this);
		} else {
			aView = new JunCalendarDateIntervalViewSwing(this);
		}
		return aView;
	}

	/**
	 * Amswer old date.
	 *
	 * @param oldDate java.util.Calendar
	 * @param newDate java.util.Calendar
	 * @return java.util.Calendar
	 * @category private
	 */
	private Calendar validateFromDate_with_(Calendar oldDate, Calendar newDate) {
		if (newDate.before(this.toCalendarDateModel().date())) {
			return newDate;
		}
		return this.toCalendarDateModel().date();
	}

	/**
	 * Amswer latest date.
	 *
	 * @param oldDate java.util.Calendar
	 * @param newDate java.util.Calendar
	 * @return java.util.Calendar
	 * @category private
	 */
	private Calendar validateToDate_with_(Calendar oldDate, Calendar newDate) {
		if (newDate.after(this.fromCalendarDateModel().date())) {
			return newDate;
		}
		return this.fromCalendarDateModel().date();
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Period (Date)");
	}
}
