package jp.co.sra.jun.goodies.calendar;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Vector;

import jp.co.sra.jun.system.dialog.JunTextInputField;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

/**
 * JunCalendarTimeController class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeController.java,v 8.15 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeController extends JunAbstractController implements MouseListener {

	private MouseEvent mEvent;

	/**
	 * Mouse button pressed event.
	 * @param e MouseEvent
	 * @category control defaults
	 */
	public void mousePressed(MouseEvent e) {
		mEvent = e;
		if (mEvent.isMetaDown()) {
			this.view()._showPopupMenu(mEvent.getX(), mEvent.getY());
		} else {
			this.buttonActivity();
		}
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void buttonActivity() {
		Point point = new Point(mEvent.getX(), mEvent.getY());
		StSymbol key;
		StRectangle box;
		for (int i = 0; i < this.getView().frames().size(); ++i) {
			Object[] array = (Object[]) this.getView().frames().get(i);
			key = (StSymbol) array[0];
			box = (StRectangle) array[array.length - 1];
			if (box.containsPoint_(point)) {
				if (key == $("label")) {
					this.labelActivity_(array);
				}
				if (key == $("hours")) {
					this.hoursActivity_(array);
				}
				if (key == $("minutes")) {
					this.minutesActivity_(array);
				}
				if (key == $("seconds")) {
					this.secondsActivity_(array);
				}
				if (key == $("button")) {
					this.buttonActivity_(array);
				}
			}
		}
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void buttonActivity_(Object[] anArray) {
		StSymbol symbol = (StSymbol) anArray[1];
		if (symbol == $("hourDown")) {
			this.getModel().hourDown();
		}
		if (symbol == $("hourUp")) {
			this.getModel().hourUp();
		}
		if (symbol == $("minuteDown")) {
			this.getModel().minuteDown();
		}
		if (symbol == $("minuteUp")) {
			this.getModel().minuteUp();
		}
		if (symbol == $("secondDown")) {
			this.getModel().secondDown();
		}
		if (symbol == $("secondUp")) {
			this.getModel().secondUp();
		}
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void labelActivity_(Object[] array) {
		return;
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void hoursActivity_(Object[] array) {
		String aString;

		if (mEvent.isShiftDown() || mEvent.isAltDown()) {
			aString = JunDialog.Request_(JunSystem.$String("Hours?"), String.valueOf(this.getModel().hours()));
		} else {
			StRectangle rect = detectFrame(this.getView().frames(), $("hours")).insetBy_(2);
			if (rect == null) {
				return;
			}
			aString = JunTextInputField.PopUpIn_forView_initialAnswer_(rect.toRectangle(), this.getView().toComponent(), String.valueOf(this.getModel().hours()));
		}
		if (aString == null || aString.length() == 0) {
			return;
		}
		StringWriter aWriter = new StringWriter();
		for (int index = 0; index < aString.length(); index++) {
			char c = aString.charAt(index);
			if (Character.isDigit(c)) {
				aWriter.write(String.valueOf(c));
			}
		}
		aString = aWriter.toString();
		if (aString.length() == 0) {
			return;
		}
		this.getModel().hours_(Integer.valueOf(aString).intValue());
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void minutesActivity_(Object[] array) {
		String aString;

		if (mEvent.isShiftDown() || mEvent.isAltDown()) {
			aString = JunDialog.Request_(JunSystem.$String("Minutes?"), String.valueOf(this.getModel().minutes()));
		} else {
			StRectangle rect = detectFrame(this.getView().frames(), $("minutes")).insetBy_(2);
			if (rect == null) {
				return;
			}
			aString = JunTextInputField.PopUpIn_forView_initialAnswer_(rect.toRectangle(), this.getView().toComponent(), String.valueOf(this.getModel().minutes()));
		}
		if (aString == null || aString.length() == 0) {
			return;
		}
		StringWriter aWriter = new StringWriter();
		for (int index = 0; index < aString.length(); index++) {
			char c = aString.charAt(index);
			if (Character.isDigit(c)) {
				aWriter.write(String.valueOf(c));
			}
		}
		aString = aWriter.toString();
		if (aString.length() == 0) {
			return;
		}
		this.getModel().minutes_(Integer.valueOf(aString).intValue());
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void secondsActivity_(Object[] array) {
		String aString;

		if (mEvent.isShiftDown() || mEvent.isAltDown()) {
			aString = JunDialog.Request_(JunSystem.$String("Seconds?"), String.valueOf(this.getModel().seconds()));
		} else {
			StRectangle rect = detectFrame(this.getView().frames(), $("seconds")).insetBy_(2);
			if (rect == null) {
				return;
			}
			aString = JunTextInputField.PopUpIn_forView_initialAnswer_(rect.toRectangle(), this.getView().toComponent(), String.valueOf(this.getModel().seconds()));
		}
		if (aString == null || aString.length() == 0) {
			return;
		}
		StringWriter aWriter = new StringWriter();
		for (int index = 0; index < aString.length(); index++) {
			char c = aString.charAt(index);
			if (Character.isDigit(c)) {
				aWriter.write(String.valueOf(c));
			}
		}
		aString = aWriter.toString();
		if (aString.length() == 0) {
			return;
		}
		this.getModel().seconds_(Integer.valueOf(aString).intValue());
	}

	/**
	 * Detect frame.
	 * @param frames java.util.Vector
	 * @param aSymbol StSymbol
	 * @return StRectangle
	 * @category private
	 */
	private StRectangle detectFrame(Vector frames, StSymbol aSymbol) {
		Iterator frameIterator = frames.iterator();
		while (frameIterator.hasNext()) {
			Object[] aFrame = (Object[]) frameIterator.next();
			if (aFrame[0] == aSymbol) {
				return (StRectangle) aFrame[aFrame.length - 1];
			}
		}
		return null;
	}

	/**
	 * Execute active button event
	 * @category accessing
	 */
	public JunCalendarTimeView getView() {
		return (JunCalendarTimeView) this.view();
	}

	/**
	 * Execute active button event
	 * @category accessing
	 */
	public JunCalendarTimeModel getModel() {
		return (JunCalendarTimeModel) this.model();
	}

}
