package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarTimeDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeDialogTestExamples.java,v 8.10 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeDialogTestExamples extends JunTestExamples {
	/**
	 * Example1: Set as the present time and open dialog.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		String[] ampm = { "AM", "PM" };
		Calendar time = JunCalendarTimeDialog.Request();
		if (time != null) {
			System.out.print(time.get(Calendar.HOUR));
			System.out.print(":" + time.get(Calendar.MINUTE));
			System.out.print(":" + time.get(Calendar.SECOND));
			System.out.println(" " + ampm[time.get(Calendar.AM_PM)]);
		}
		return true;
	}

	/**
	 * Example2: Set as the present time, set label "Select time." and open dialog.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		String[] ampm = { "AM", "PM" };
		Calendar time = JunCalendarTimeDialog.Request_(JunSystem.$String("Select time."));
		if (time != null) {
			System.out.print(time.get(Calendar.HOUR));
			System.out.print(":" + time.get(Calendar.MINUTE));
			System.out.print(":" + time.get(Calendar.SECOND));
			System.out.println(" " + ampm[time.get(Calendar.AM_PM)]);
		}
		return true;
	}

	/**
	 * Example3: Set time, set label "Select time." and open dialog.
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		String[] ampm = { "AM", "PM" };
		Calendar time = Calendar.getInstance();
		time.add(Calendar.SECOND, 100);
		Calendar answer = JunCalendarTimeDialog.Request_initialTime_(JunSystem.$String("Select time."), time);
		if (answer != null) {
			System.out.print(answer.get(Calendar.HOUR));
			System.out.print(":" + answer.get(Calendar.MINUTE));
			System.out.print(":" + answer.get(Calendar.SECOND));
			System.out.println(" " + ampm[answer.get(Calendar.AM_PM)]);
		}
		return true;
	}

	/**
	 * Example4: Set time, set label "Select time.", set button action and open dialog.
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		String[] ampm = { "AM", "PM" };
		Calendar time = Calendar.getInstance();
		time.add(Calendar.SECOND, 100);
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarTimeModel timeModel = (JunCalendarTimeModel) aModel;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("	" + timeModel);
				return (Object) Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarTimeModel timeModel = (JunCalendarTimeModel) aModel;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("	" + timeModel);
				return (Object) Boolean.TRUE;
			}
		};
		Calendar answer = JunCalendarTimeDialog.Request_initialTime_onAccept_onCancel_(JunSystem.$String("Select time."), time, acceptBlock, cancelBlock);
		if (answer != null) {
			System.out.print(answer.get(Calendar.HOUR));
			System.out.print(":" + answer.get(Calendar.MINUTE));
			System.out.print(":" + answer.get(Calendar.SECOND));
			System.out.println(" " + ampm[answer.get(Calendar.AM_PM)]);
		}
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(java.lang.String[] args) {
		new JunCalendarTimeDialogTestExamples();
	}
}
