package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.util.Calendar;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunCalendarTimeIntervalDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalDialog.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeIntervalDialog extends StSimpleDialog {
	protected JunCalendarTimeIntervalModel calendarTimeIntervalModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Create a new instance of <code>JunCalendarTimeIntervalDialog</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarTimeIntervalDialog() {
		super();
	}

	/**
	 * JunCalendarTimeIntervalDialog.Request()
	 * 
	 * @return JunCalendarTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarTimeModel[] Request() {
		return JunCalendarTimeIntervalDialog.Request_(null);
	}

	/**
	 * JunCalendarTimeIntervalDialog.Request_("Select date.")
	 * 
	 * @param messageString java.lang.String
	 * @return JunCalendarTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarTimeModel[] Request_(String messageString) {
		Calendar[] timeArray = { Calendar.getInstance(), Calendar.getInstance() };
		return JunCalendarTimeIntervalDialog.Request_initialTime_(messageString, timeArray);
	}

	/**
	 * JunCalendarTimeIntervalDialog.Request_initialTime_("Select date.", Calendar.getInstance());
	 * 
	 * @param messageString java.lang.String
	 * @param timeArray java.util.Calendar[]
	 * @return JunCalendarTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarTimeModel[] Request_initialTime_(String messageString, Calendar[] timeArray) {
		return JunCalendarTimeIntervalDialog.Request_initialTime_onAccept_onCancel_(messageString, timeArray, null, null);
	}

	/**
	 * JunCalendarTimeIntervalDialog.Request_initialTime_onAccept_onCancel_(
	 * 	"Select date.",
	 *	Calendar.getInstance(),
	 *	null,
	 *	null)
	 *
	 * @param messageString java.lang.String
	 * @param timeArray java.util.Calendar[]
	 * @param anAcceptBlock StBlockClosure
	 * @param aCancelBlock StBlockClosure
	 * @return JunCalendarTimeModel[]
	 * @category Utilities
	 */
	public static JunCalendarTimeModel[] Request_initialTime_onAccept_onCancel_(String messageString, Calendar[] timeArray, StBlockClosure anAcceptBlock, StBlockClosure aCancelBlock) {
		JunCalendarTimeIntervalDialog calendarTimeIntervalDialog = new JunCalendarTimeIntervalDialog();
		if (!(timeArray == null)) {
			if (timeArray.length > 1) {
				calendarTimeIntervalDialog.calendarTimeIntervalModel_(JunCalendarTimeIntervalModel.From_to_(timeArray[0], timeArray[timeArray.length - 1]));
			}
		}
		Dialog dialog = calendarTimeIntervalDialog.allButOpenDialog();
		if (!(messageString == null)) {
			dialog.setTitle(messageString);
		}
		if (!(anAcceptBlock == null)) {
			calendarTimeIntervalDialog.acceptBlock_(anAcceptBlock);
		}
		if (!(aCancelBlock == null)) {
			calendarTimeIntervalDialog.cancelBlock_(aCancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (calendarTimeIntervalDialog.accept()._booleanValue()) {
			return calendarTimeIntervalDialog.calendarTimeIntervalModel().times();
		} else {
			return null;
		}
	}

	/**
	 * Set an action accept to a block..
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Return a JunCalendarTimeIntervalModel instance.
	 * @return JunCalendarTimeIntervalModel
	 * @category accessing
	 */
	public JunCalendarTimeIntervalModel calendarTimeIntervalModel() {
		if (calendarTimeIntervalModel == null) {
			calendarTimeIntervalModel = new JunCalendarTimeIntervalModel();
		}
		return calendarTimeIntervalModel;
	}

	/**
	 * Set new insntace of JunCalendarTimeIntervalModel.
	 * @param aCalendarTimeIntervalModel JunCalendarTimeIntervalModel
	 * @category accessing
	 */
	public void calendarTimeIntervalModel_(JunCalendarTimeIntervalModel aCalendarTimeIntervalModel) {
		calendarTimeIntervalModel = aCalendarTimeIntervalModel;
	}

	/**
	 * Set a calcel action to a block.
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Return result of accept button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object acceptButtonPressed() {
		if (!(acceptBlock == null)) {
			return acceptBlock.value_(this.calendarTimeIntervalModel());
		}
		return new Boolean(true);
	}

	/**
	 * Return result of cancel button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object cancelButtonPressed() {
		if (!(cancelBlock == null)) {
			return cancelBlock.value_(this.calendarTimeIntervalModel());
		}
		return new Boolean(true);
	}

	/**
	 * Answer a default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category accessing
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunCalendarTimeIntervalDialogViewAwt(this);
		} else {
			return new JunCalendarTimeIntervalDialogViewSwing(this);
		}
	}

	/**
	 * Initialize the ApplicationModel when created.
	 *
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Period (Time) Dialog");
	}
}
