package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarTimeIntervalModelTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalModelTestExamples.java,v 8.12 2008/02/20 06:31:13 nisinaka Exp $
 */
public class JunCalendarTimeIntervalModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunCalendarTimeIntervalModel.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarTimeIntervalModel calendarTimeIntervalModel = new JunCalendarTimeIntervalModel();
		calendarTimeIntervalModel.open();
		return true;
	}

	/**
	 * Example2: Set time and open a JunCalendarTimeIntervalModel.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		Calendar now = Calendar.getInstance();
		Calendar after7hours = Calendar.getInstance();
		int[] ampm = { 0, 12 };
		after7hours.set(after7hours.get(Calendar.YEAR), after7hours.get(Calendar.MONTH), after7hours.get(Calendar.DATE), after7hours.get(Calendar.HOUR) + ampm[after7hours.get(Calendar.AM_PM)] + 7, after7hours.get(Calendar.MINUTE), after7hours
				.get(Calendar.SECOND));
		JunCalendarTimeIntervalModel calendarTimeIntervalModel = JunCalendarTimeIntervalModel.From_to_(now, after7hours);
		calendarTimeIntervalModel.open();
		return true;
	}

	/**
	 * Example3: Set time and open a JunCalendarTimeIntervalModel.
	 *
	 * @return true
	 */
	public static boolean Example3() {
		Calendar now = Calendar.getInstance();
		Calendar after7hours = Calendar.getInstance();
		int[] ampm = { 0, 12 };
		after7hours.set(after7hours.get(Calendar.YEAR), after7hours.get(Calendar.MONTH), after7hours.get(Calendar.DATE), after7hours.get(Calendar.HOUR) + ampm[after7hours.get(Calendar.AM_PM)] - 7,
		//error setting
				after7hours.get(Calendar.MINUTE), after7hours.get(Calendar.SECOND));
		JunCalendarTimeIntervalModel calendarTimeIntervalModel = JunCalendarTimeIntervalModel.From_to_(now, after7hours);
		calendarTimeIntervalModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 */
	public static void main(String args[]) {
		new JunCalendarTimeIntervalModelTestExamples();
	}
}
