package jp.co.sra.jun.goodies.catalog;

import java.awt.Point;
import java.io.File;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageCatalogTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/05/21 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageCatalogTestExamples.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunImageCatalogTestExamples extends JunTestExamples {
	/**
	 * Example 1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunImageCatalog imageCatalog = new JunImageCatalog();
		imageCatalog.make();
		imageCatalog.show();

		return true;
	}

	/**
	 * Example 2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunImageCatalog imageCatalog = new JunImageCatalog(aDirectory);
		imageCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				System.out.println((String) m);
				return null;
			}
		});
		imageCatalog.make();
		imageCatalog.show();

		return true;
	}

	/**
	 * Example 3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		final JunImageCatalog imageCatalog = new JunImageCatalog(aDirectory);
		final JunProgress aProgress = new JunProgress();
		imageCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				aProgress.message_((String) m);
				return null;
			}
		});
		imageCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
			public Object value_(Object v) {
				aProgress.value_(((Number) v).floatValue());
				return null;
			}
		});
		aProgress.do_(new StBlockClosure() {
			public Object value() {
				imageCatalog.make();
				return null;
			}
		});
		imageCatalog.show();

		return true;
	}

	/**
	 * Example 4.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		final JunImageCatalog imageCatalog = new JunImageCatalog(aDirectory);
		imageCatalog.visualClip_(new Point(400, 350));
		imageCatalog.thumbnailImageSize_(32);
		imageCatalog.numberOfColumns_(3);
		imageCatalog.withFileName_(true);
		final JunProgress aProgress = new JunProgress();
		imageCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				aProgress.message_((String) m);
				return null;
			}
		});
		imageCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
			public Object value_(Object v) {
				aProgress.value_(((Number) v).floatValue());
				return null;
			}
		});
		aProgress.do_(new StBlockClosure() {
			public Object value() {
				imageCatalog.make();
				return null;
			}
		});
		imageCatalog.show();

		return true;
	}

	/**
	 * Example 5.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog anImageCatalog = JunImageCatalog.Dive_(aDirectory);
		anImageCatalog.show();

		return true;
	}

	/**
	 * Example 6.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog anImageCatalog = JunImageCatalog.Dive_block_(aDirectory, new StBlockClosure() {
			public Object value_(Object anObject) {
				final JunImageCatalog imageCatalog = (JunImageCatalog) anObject;
				imageCatalog.visualClip_(new Point(128, 128));
				imageCatalog.thumbnailImageSize_(32);
				imageCatalog.numberOfColumns_(3);
				imageCatalog.withFileName_(true);
				final JunProgress aProgress = new JunProgress();
				imageCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
					public Object value_(Object m) {
						aProgress.message_((String) m);
						return null;
					}
				});
				imageCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
					public Object value_(Object v) {
						aProgress.value_(((Number) v).floatValue());
						return null;
					}
				});
				aProgress.do_(new StBlockClosure() {
					public Object value() {
						imageCatalog.make();
						return null;
					}
				});
				return null;
			}
		});
		anImageCatalog.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunImageCatalogTestExamples();
	}
}
