package jp.co.sra.jun.goodies.catalog;

import java.io.File;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunVisualCatalogTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/05/27 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVisualCatalogTestExamples.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunVisualCatalogTestExamples extends JunTestExamples {
	/**
	 * Example 1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunVisualCatalog visualCatalog = new JunVisualCatalog();
		visualCatalog.make();
		visualCatalog.show();

		return true;
	}

	/**
	 * Example 2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog visualCatalog = new JunVisualCatalog(aDirectory);
		visualCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				System.out.println((String) m);
				return null;
			}
		});
		visualCatalog.make();
		visualCatalog.show();

		return true;
	}

	/**
	 * Example 3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		final JunVisualCatalog visualCatalog = new JunVisualCatalog(aDirectory);
		final JunProgress aProgress = new JunProgress();
		visualCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				aProgress.message_((String) m);
				return null;
			}
		});
		visualCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
			public Object value_(Object v) {
				aProgress.value_(((Number) v).floatValue());
				return null;
			}
		});
		aProgress.do_(new StBlockClosure() {
			public Object value() {
				visualCatalog.make();
				return null;
			}
		});
		visualCatalog.show();

		return true;
	}

	/**
	 * Example 4.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		final JunVisualCatalog visualCatalog = new JunVisualCatalog(aDirectory);
		visualCatalog.thumbnailImageSize_(32);
		visualCatalog.numberOfColumns_(3);
		visualCatalog.withFileName_(true);
		final JunProgress aProgress = new JunProgress();
		visualCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				aProgress.message_((String) m);
				return null;
			}
		});
		visualCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
			public Object value_(Object v) {
				aProgress.value_(((Number) v).floatValue());
				return null;
			}
		});
		aProgress.do_(new StBlockClosure() {
			public Object value() {
				visualCatalog.make();
				return null;
			}
		});
		visualCatalog.show();

		return true;
	}

	/**
	 * Example 5.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog visualCatalog = JunVisualCatalog.Dive_(aDirectory);
		visualCatalog.show();

		return true;
	}

	/**
	 * Example 6.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog visualCatalog = JunVisualCatalog.Dive_block_(aDirectory, new StBlockClosure() {
			public Object value_(Object anObject) {
				final JunVisualCatalog visualCatalog = (JunVisualCatalog) anObject;
				visualCatalog.thumbnailImageSize_(32);
				visualCatalog.numberOfColumns_(3);
				visualCatalog.withFileName_(true);
				final JunProgress aProgress = new JunProgress();
				visualCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
					public Object value_(Object m) {
						aProgress.message_((String) m);
						return null;
					}
				});
				visualCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
					public Object value_(Object v) {
						aProgress.value_(((Number) v).floatValue());
						return null;
					}
				});
				aProgress.do_(new StBlockClosure() {
					public Object value() {
						visualCatalog.make();
						return null;
					}
				});
				return null;
			}
		});
		visualCatalog.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunVisualCatalogTestExamples();
	}
}
