package jp.co.sra.jun.goodies.colors;

import java.awt.Color;

/**
 * JunColorBarHSB class
 * 
 *  @author    nisinaka
 *  @created   2004/06/11 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun452 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarHSB.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarHSB extends JunColorBarModel {

	protected double[] hueBounds;
	protected double[] saturationBounds;
	protected double[] brightnessBounds;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		hueBounds = null;
		saturationBounds = null;
		brightnessBounds = null;
	}

	/**
	 * Answer my current hue bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] hueBounds() {
		if (hueBounds == null) {
			hueBounds = new double[] { 0, 1 };
		}
		return hueBounds;
	}

	/**
	 * Set my new hue bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void hueBounds_(double[] newBounds) {
		hueBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer my current saturation bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] saturationBounds() {
		if (saturationBounds == null) {
			saturationBounds = new double[] { 1, 1 };
		}
		return saturationBounds;
	}

	/**
	 * Set my new saturation bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void saturationBounds_(double[] newBounds) {
		saturationBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer my current brightness bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] brightnessBounds() {
		if (brightnessBounds == null) {
			brightnessBounds = new double[] { 1, 1 };
		}
		return brightnessBounds;
	}

	/**
	 * Set my new brightness bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void brightnessBounds_(double[] newBounds) {
		brightnessBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer the color which correspond to the normalized value.
	 * 
	 * @param normalizedValue double
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.goodies.colors.JunColorBarModel#getColor_(double)
	 * @category private
	 */
	protected Color getColor_(double normalizedValue) {
		double hue = (this.hueBounds()[1] - this.hueBounds()[0]) * normalizedValue + this.hueBounds[0];
		double saturation = (this.saturationBounds()[1] - this.saturationBounds()[0]) * normalizedValue + this.saturationBounds[0];
		double brightness = (this.brightnessBounds()[1] - this.brightnessBounds()[0]) * normalizedValue + this.brightnessBounds[0];
		return Color.getHSBColor((float) hue, (float) saturation, (float) brightness);
	}

}
