package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.dialog.JunTextInputField;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;

/**
 * JunColorChoiceController class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/05 (by Hirotsugu Kondo)
 *  @updated   1999/08/31 (by Mitsuhiro Asada)
 *  @updated   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/10/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun624 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceController.java,v 8.12 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceController extends JunAbstractController implements MouseListener, MouseMotionListener {

	/**
	 * Add myself as a listener of the view.
	 * 
	 * @param newView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category initialize-release
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}

	/**
	 * Answer this model as JunColorChoiceModel.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category model accessing
	 */
	protected JunColorChoiceModel getColorChoiceModel() {
		return (JunColorChoiceModel) this.model();
	}

	/**
	 * Answer this view as JunColorChoiceView.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceView
	 * @category view accessing
	 */
	protected JunColorChoiceView getColorChoiceView() {
		return (JunColorChoiceView) this.view();
	}

	/**
	 * Invoked when the mouse has been clicked on a component.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category events
	 */
	public void mouseClicked(MouseEvent event) {
		if (event.isMetaDown() || event.isPopupTrigger()) {
			super.mouseClicked(event);
			return;
		}

		Point point = event.getPoint();
		JunColorChoiceView view = this.getColorChoiceView();
		if (view.spuitArea().contains(point)) {
			Color color = JunColorSpuit.Request();
			if (event.isShiftDown() == false) {
				this.getColorChoiceModel().color_(color);
			}
		}
	}

	/**
	 * Invoked when the mouse button has been moved.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category events
	 */
	public void mouseDragged(MouseEvent event) {
		Point point = event.getPoint();
		JunColorChoiceView view = this.getColorChoiceView();
		if (view.plateArea().contains(point) || view.barArea().contains(point)) {
			this.mousePressed(event);
		}
	}

	/**
	 * Tempolary cursor set method. Not called now.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category events
	 */
	public void mouseMoved(MouseEvent event) {
		Point point = event.getPoint();
		JunColorChoiceView view = this.getColorChoiceView();
		if (view.plateArea().contains(point) || view.barArea().contains(point) || view.hueArea().contains(point) || view.saturationArea().contains(point) || view.brightnessArea().contains(point) || view.colorArea().contains(point)) {
			view.toComponent().setCursor(JunCursors.CrossCursor());
		} else {
			view.toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	}

	/**
	 * Invoked when a mouse button has been pressed.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category events
	 */
	public void mousePressed(MouseEvent event) {
		if (event.isMetaDown() || event.isPopupTrigger()) {
			super.mousePressed(event);
			return;
		}

		Point point = event.getPoint();
		JunColorChoiceView view = this.getColorChoiceView();
		//Point dialogPoint = view.topComponent().getLocation();
		//dialogPoint.translate(point.x, point.y);

		if (view.plateArea().contains(point)) {
			double x = (double) (point.x - view.plateArea().getLocation().x) / (view.plateArea().width - 1.0);
			double y = (double) (point.y - view.plateArea().getLocation().y) / (view.plateArea().height - 1.0);
			Jun2dPoint jPoint = new Jun2dPoint(x, y);
			this.getColorChoiceModel().xy_(jPoint);
		} else if (view.barArea().contains(point)) {
			double z = (double) (point.y - view.barArea().getLocation().y) / (view.barArea().height - 1.0);
			this.getColorChoiceModel().z_(z);
		} else if (view.hueArea().contains(point)) {
			this.inputHueActivity(event);
		} else if (view.saturationArea().contains(point)) {
			this.inputSaturationActivity(event);
		} else if (view.brightnessArea().contains(point)) {
			this.inputBrightnessActivity(event);
		} else if (view.colorArea().contains(point)) {
			System.out.println(view.colorString());
		}
	}

	/**
	 * Activity for the hue input.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void inputHueActivity(MouseEvent event) {
		JunColorChoiceView colorChoiceView = this.getColorChoiceView();

		String aString = null;
		if (event.isShiftDown() || event.isAltDown()) {
			aString = JunDialog.Request_($String("hue?"), colorChoiceView.hueString());
		} else {
			aString = JunTextInputField.PopUpIn_forView_initialAnswer_(colorChoiceView.hueArea(), colorChoiceView.toComponent(), colorChoiceView.hueString());
		}

		if (aString != null && aString.length() > 0) {
			try {
				double value = Double.parseDouble(aString);
				if (0 <= value && value <= 1) {
					this.getColorChoiceModel().hue_(value);
				}
			} catch (NumberFormatException e) {
			}
		}
	}

	/**
	 * Activity for the saturation input.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void inputSaturationActivity(MouseEvent event) {
		JunColorChoiceView colorChoiceView = this.getColorChoiceView();

		String aString = null;
		if (event.isShiftDown() || event.isAltDown()) {
			aString = JunDialog.Request_($String("saturation?"), colorChoiceView.saturationString());
		} else {
			aString = JunTextInputField.PopUpIn_forView_initialAnswer_(colorChoiceView.saturationArea(), colorChoiceView.toComponent(), colorChoiceView.saturationString());
		}

		if (aString != null && aString.length() > 0) {
			try {
				double value = Double.parseDouble(aString);
				if (0 <= value && value <= 1) {
					this.getColorChoiceModel().saturation_(value);
				}
			} catch (NumberFormatException e) {
			}
		}
	}

	/**
	 * Activity for the brightness input.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void inputBrightnessActivity(MouseEvent event) {
		JunColorChoiceView colorChoiceView = this.getColorChoiceView();

		String aString = null;
		if (event.isShiftDown() || event.isAltDown()) {
			aString = JunDialog.Request_($String("brightness?"), colorChoiceView.brightnessString());
		} else {
			aString = JunTextInputField.PopUpIn_forView_initialAnswer_(colorChoiceView.brightnessArea(), colorChoiceView.toComponent(), colorChoiceView.brightnessString());
		}

		if (aString != null && aString.length() > 0) {
			try {
				double value = Double.parseDouble(aString);
				if (0 <= value && value <= 1) {
					this.getColorChoiceModel().brightness_(value);
				}
			} catch (NumberFormatException e) {
			}
		}
	}

}