package jp.co.sra.jun.goodies.colors;

import java.awt.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;

/**
 * JunColorChoiceSBH class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/05 (by Hirotsugu Kondo)
 *  @updated   1999/08/31 (by m-asada)
 *  @updated   2003/04/02 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceSBH.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceSBH extends JunColorChoiceModel {
	protected static StImage[] bars;
	protected static StImage[] plates;

	static {
		plates = _InitializePlates();
		bars = _InitializeBars();
	}

	/**
	 * Initialize color bars.
	 * 
	 * @return java.lang.reflect.Array of StImage
	 * @category Class initialization
	 */
	static StImage[] _InitializeBars() {
		int gap = _Gap();
		int interval = _Intervals();
		int ySize = interval / gap;
		int zSize = interval / gap;
		int width = _barArea().width;
		StImage[] images = new StImage[zSize];
		for (int z = 0; z < zSize; z++) {
			int[] pixels = new int[interval * width];
			for (int y = 0; y < ySize; y++) {
				double hue = (y * 1.0) / ySize;
				double saturation = 1.0;
				double brightness = 1.0;
				Color color = Color.getHSBColor((float) hue, (float) saturation, (float) brightness);
				for (int dy = 0; dy < gap; dy++) {
					for (int dx = 0; dx < width; dx++) {
						pixels[((y * gap + dy) * width) + dx] = color.getRGB();
					}
				}
			}
			images[z] = new StImage(width, interval, pixels);
		}

		return images;
	}

	/**
	 * Initialize color plates.
	 * 
	 * @return java.lang.reflect.Array of StImage
	 * @category Class initialization
	 */
	static StImage[] _InitializePlates() {
		int gap = _Gap();
		int interval = _Intervals();
		int size = interval / gap;
		StImage[] images = new StImage[size];
		for (int z = 0; z < size; z++) {
			int[] pixels = new int[interval * interval];
			for (int y = 0; y < size; y++) {
				for (int x = 0; x < size; x++) {
					double hue = (z * 1.0) / size;
					double saturation = (x * 1.0) / size;
					double brightness = 1 - (y * 1.0 / size);
					Color color = Color.getHSBColor((float) hue, (float) saturation, (float) brightness);
					for (int dy = 0; dy < gap; dy++) {
						for (int dx = 0; dx < gap; dx++) {
							pixels[((y * gap + dy) * interval) + (x * gap) + dx] = color.getRGB();
						}
					}
				}
			}
			images[z] = new StImage(interval, interval, pixels);
		}

		return images;
	}

	/**
	 * Answer the images of bar.
	 * 
	 * @return jp.co.sra.smalltalk.StImage[]
	 * @category image accessing
	 */
	public StImage[] bars() {
		StImage[] images = this.bars;
		return images;
	}

	/**
	 * Answer the brighness value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double brightness() {
		double value = 1 - this.xy().y();

		return value;
	}

	/**
	 * Set the brighness value.
	 * 
	 * @param value double
	 * @category accessing
	 */
	public void brightness_(double value) {
		this.xy_(new Jun2dPoint(this.xy().x() - 0, 1 - value));
	}

	/**
	 * Set the color and mapping this.
	 * 
	 * @param color java.awt.Color
	 * @category accessing
	 */
	public void color_(Color color) {
		this.z_(StColorValue._GetHue(color));
		this.xy_(new Jun2dPoint(StColorValue._GetSaturation(color), (1 - (StColorValue._GetBrightness(color)))));
		this.changed_($("color"));
	}

	/**
	 * Answer the hue value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double hue() {
		double value = this.z();
		return value;
	}

	/**
	 * Set the hue value.
	 * 
	 * @param value double
	 * @category accessing
	 */
	public void hue_(double value) {
		this.z_(value);
	}

	/**
	 * Answer the images of color plate.
	 * 
	 * @return jp.co.sra.smalltalk.StImage[]
	 * @category image accessing
	 */
	public StImage[] plates() {
		StImage[] images = this.plates;
		return images;
	}

	/**
	 * Answer the saturation value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double saturation() {
		double value = this.xy().x();
		return value;
	}

	/**
	 * Set the saturation value.
	 * 
	 * @param value double
	 * @category accessing
	 */
	public void saturation_(double value) {
		this.xy_(new Jun2dPoint(value, this.xy().y()));
	}
}
