package jp.co.sra.jun.goodies.display;

import java.awt.Rectangle;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDisplayModelTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/16 (by Hirotsugu Kondo)
 *  @updated   2003/03/19 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDisplayModelTestExamples.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunDisplayModelTestExamples extends JunTestExamples {

	/**
	 * Example1: Show an image.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunDisplayModel model = new JunDisplayModel(StImage._OfArea(new Rectangle(0, 0, 300, 200)));
		model.open();
		return true;
	}

	/**
	 * Example1X: Show an image without scrollbars.
	 * 
	 * @return boolean
	 */
	public static boolean Example1X() {
		JunDisplayModel model = new JunDisplayModel(StImage._OfArea(new Rectangle(0, 0, 300, 200)));
		model._isScrollable(false);
		model.open();
		return true;
	}

	/**
	 * Example2: Show a string.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunDisplayModel model = new JunDisplayModel("The sun is going down below the horizon.\nThe evening in Hawaii is very beautiful.");
		model.open();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunDisplayModelTestExamples();
	}
}
