package jp.co.sra.jun.goodies.display;

import java.awt.Component;
import java.awt.Dimension;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunDisplayView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/11/11 (by MATSUDA Ryouichi)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/19 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDisplayView.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public interface JunDisplayView extends JunAbstractView {

	/**
	 * Answer my model as JunDisplayModel.
	 * 
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category model accessing
	 */
	public JunDisplayModel getDisplayModel();

	/**
	 * Answer my viewport size.
	 * 
	 * @return java.awt.Dimension
	 * @category bounds accessing
	 */
	public Dimension _getViewportSize();

	/**
	 * Answer my canvas as Component.
	 * 
	 * @return java.awt.Component
	 * @category user interface
	 */
	public Component canvasComponent();

}
