package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.util.Map;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunLabelElement class
 * 
 *  @author    m-asada
 *  @created   2005/07/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLabelElement.java,v 8.10 2008/02/20 06:31:23 nisinaka Exp $
 */
public class JunLabelElement extends JunTextElement {
	protected JunLinkElement baseElement;

	protected transient long baseElementId;

	public static DataFlavor DataFlavor = new DataFlavor(JunLabelElement.class, "JunLabelElement");

	/**
	 * Create a new instance of <code>JunLabelElement</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunLabelElement() {
		super();
	}

	/**
	 * Create a new instance of <code>JunLabelElement</code> and initialize it.
	 * 
	 * @param newBaseElement jp.co.sra.jun.goodies.drawing.element.JunLinkElement
	 * @category Instance creation
	 */
	public JunLabelElement(JunLinkElement newBaseElement) {
		super();
		this.baseElement_(newBaseElement);
	}

	/**
	 * Create a new instance of <code>JunLabelElement</code> and initialize it.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunLabelElement(JunLispList aList) {
		super(aList);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		baseElement = null;
		baseElementId = Long.MIN_VALUE;
	}

	/**
	 * Answer the reciver's base element.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.element.JunLinkElement
	 * @throws java.lang.IllegalStateException
	 * @category accessing
	 */
	public JunLinkElement baseElement() {
		if (baseElement == null && this.baseElementId() > Long.MIN_VALUE) {
			JunDrawingElement anElement = this.map().findElement_(this.baseElementId());
			if (anElement != null && anElement.isLink()) {
				this.baseElement_((JunLinkElement) anElement);
			} else {
				throw new IllegalStateException("the base element id '" + this.baseElementId() + "' don't find this map object.");
			}
		}
		return baseElement;
	}

	/**
	 * Set the reciver's base element.
	 * 
	 * @param anElement jp.co.sra.jun.goodies.drawing.element.JunLinkElement
	 * @category accessing
	 */
	public void baseElement_(JunLinkElement anElement) {
		baseElement = anElement;
		this.baseElementId_(Long.MIN_VALUE);
	}

	/**
	 * Set the receiver's location point.
	 * 
	 * @param aPoint java.awt.Point
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#location_(java.awt.Point)
	 * @category bounds accessing
	 */
	public void location_(Point aPoint) {
		super.location_(aPoint);
		if (this.baseElement() != null) {
			this.baseElement().flushLabelElementPoints();
		}
	}

	/**
	 * Set the receiver's extent size.
	 * 
	 * @param aDimension java.awt.Dimension
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#extent_(java.awt.Dimension)
	 * @category bounds accessing
	 */
	public void extent_(Dimension aDimension) {
		super.extent_(aDimension);
		if (this.baseElement() != null) {
			this.baseElement().flushLabelElementPoints();
		}
	}

	/**
	 * Move the receiver's location.
	 * 
	 * @param aPoint java.awt.Point
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#location_(java.awt.Point)
	 * @category bounds accessing
	 */
	public void moveLabel_(Point aPoint) {
		super.location_(aPoint);
	}

	/**
	 * Answer true if receiver's base element is exist, otherwise false.
	 * 
	 * @return boolean
	 * @category checking
	 */
	public boolean checkElement() {
		try {
			this.baseElement();
			return true;
		} catch (IllegalStateException e) {
			return false;
		}
	}

	/**
	 * Do the receiver specific copy process after the shallow copy.
	 * 
	 * @param context java.util.Map
	 * @return jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#postCopy(java.util.Map)
	 * @category copying
	 */
	public JunDrawingVisual postCopy(Map context) {
		JunLinkElement base = this.baseElement();
		super.postCopy(context);
		this.baseElement_((JunLinkElement) (context.containsKey(base) ? context.get(base) : base.copy(context)));
		return this;
	}

	/**
	 * Answer true if receiver is label element, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#isLabel()
	 */
	public boolean isLabel() {
		return true;
	}

	/**
	 * Returns an array of DataFlavor objects indicating the flavors the data can be provided in. The array should be
	 * ordered according to preference for providing the data (from most richly descriptive to least descriptive).
	 * 
	 * @return java.awt.datatransfer.DataFlavor[]
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#getTransferDataFlavors()
	 * @category transfering
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { JunLabelElement.DataFlavor };
	}

	/**
	 * Convert the receiver to the lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#toLispList()
	 * @category lisp support
	 */
	public JunLispCons toLispList() {
		JunLispCons list = super.toLispList();
		list.add_(this.baseElementToLispList());
		return list;
	}

	/**
	 * Convert the base element to the lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	protected JunLispCons baseElementToLispList() {
		JunLispCons list = this.lispCons();
		list.head_($("base"));
		list.tail_(new Long(this.baseElement().id()));
		return list;
	}

	/**
	 * Get the receiver from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#fromLispList_(jp.co.sra.jun.goodies.lisp.JunLispList)
	 * @category lisp support
	 */
	public void fromLispList_(JunLispList aList) {
		super.fromLispList_(aList);
		this.baseElementFromLispList_(aList);
	}

	/**
	 * Get the base element id from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void baseElementFromLispList_(JunLispList aList) {
		JunLispList list = (JunLispList) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object car) {
				return new Boolean(car instanceof JunLispCons && ((JunLispCons) car).head() == $("base"));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}
		this.baseElement_(null);
		this.baseElementId_(((Number) list.tail()).longValue());
	}

	/**
	 * Answer the reciver's base element id.
	 * 
	 * @return long
	 * @category private
	 */
	public long baseElementId() {
		return baseElementId;
	}

	/**
	 * Set the reciver's base element id.
	 * 
	 * @param aNumber long
	 * @category private
	 */
	public void baseElementId_(long aNumber) {
		baseElementId = aNumber;
	}
}
