package jp.co.sra.jun.goodies.drawing.map;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunDrawingMapView interface
 * 
 *  @author    m-asada
 *  @created   2005/03/01 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDrawingMapView.java,v 8.11 2008/02/20 06:31:24 nisinaka Exp $
 */
public interface JunDrawingMapView extends JunAbstractView {
	/**
	 * Answer the receiver's edit mode.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int editMode();

	/**
	 * Set the receiver's edit mode.
	 * 
	 * @param newEditMode int
	 * @category accessing
	 */
	public void editMode_(int newEditMode);

	/**
	 * Answer the receiver's bounds.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle getBounds();

	/**
	 * Answer the receiver's model as JunDrawingMapModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModel
	 * @category model accessing
	 */
	public JunDrawingMapModel getDrawingMapModel();

	/**
	 * Answer the receiver's controller as JunDrawingMapController.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.map.JunDrawingMapController
	 * @category accessing
	 */
	public JunDrawingMapController getDrawingMapController();

	/**
	 * Answer the rectangle contains the elements.
	 * 
	 * @return java.awt.Rectangle or null
	 * @param anArray jp.co.sra.jun.goodies.drawing.element.JunDrawingElement[]
	 * @category accessing
	 */
	public Rectangle areaOfElements_(JunDrawingElement[] anArray);

	/**
	 * Answer the center point on scroll pane.
	 * 
	 * @return java.awt.Point
	 * @category bounds accessing
	 */
	public Point centerPointOnScrollPane();

	/**
	 * Display the canvas part of the receiver on the graphics.
	 * The subclasses may override this.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayCanvasOn_(Graphics aGraphics);

	/**
	 * Display the scaled image on a graphics with the unscaled clipping bounds.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @param anImage java.awt.Image
	 * @param aRectangle java.awt.Rectangle
	 * @category displaying
	 */
	public void displayCanvasOn_scaledImage_unscaledClip_(Graphics aGraphics, Image anImage, Rectangle aRectangle);

	/**
	 * Invalidate the Rectangle aRectangle. If aBoolean is false, repair later.
	 * Propagate a damage rectangle up the containment hierarchy.
	 * This will result in a displayOn: aGraphicsContext being sent to the receiver.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @param aBoolean boolean
	 * @category displaying
	 */
	public void _invalidateRectangle_repairNow_(Rectangle aRectangle, boolean aBoolean);

	/**
	 * Create off screen image.
	 * 
	 * @return java.awt.Image
	 * @category displaying
	 */
	public Image createOffScreen();

	/**
	 * Answer off screen image.
	 * 
	 * @return java.awt.Image
	 * @category displaying
	 */
	public Image offScreen();

	/**
	 * Answer the graphics context with zooming factor from an image.
	 * 
	 * @param anImage java.awt.Image
	 * @return java.awt.Graphics2D
	 * @category displaying
	 */
	public Graphics2D graphicsWithZoomFrom_(Image anImage);
}
