package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunPathPropertiesViewSwing class
 * 
 *  @author    m-asada
 *  @created   2005/05/23 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPathPropertiesViewSwing.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunPathPropertiesViewSwing extends JunVertexesPropertiesViewSwing implements JunPathPropertiesView {
	protected ButtonGroup beginArrowStyle;
	protected JRadioButton beginArrowStyleSquare;
	protected JRadioButton beginArrowStyleArrow;
	protected JRadioButton beginArrowStyleDiamond;
	protected JRadioButton beginArrowStyleCircle;
	protected ButtonGroup endArrowStyle;
	protected JRadioButton endArrowStyleSquare;
	protected JRadioButton endArrowStyleArrow;
	protected JRadioButton endArrowStyleDiamond;
	protected JRadioButton endArrowStyleCircle;

	/**
	 * Create a new instance of <code>JunPathPropertiesViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunPathPropertiesViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunPathPropertiesViewSwing</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesModel
	 * @category Instance creation
	 */
	public JunPathPropertiesViewSwing(JunPathPropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Answer the model as JunPathPropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesView#getPathModel()
	 * @category model accessing
	 */
	public JunPathPropertiesModel getPathModel() {
		return (JunPathPropertiesModel) this.model();
	}

	/**
	 * Initialize the JunRectangularShapePropertiesViewAwt.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		beginArrowStyle = null;
		beginArrowStyleSquare = null;
		beginArrowStyleArrow = null;
		beginArrowStyleDiamond = null;
		beginArrowStyleCircle = null;
		endArrowStyle = null;
		endArrowStyleSquare = null;
		endArrowStyleArrow = null;
		endArrowStyleDiamond = null;
		endArrowStyleCircle = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		JLabel label = new JLabel(JunSystem.$String("Line color") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 0, 0f, 0, 0f, 70, 0f, 30));
		this.add(this.foregroundColorChoiceView(), WindowSpecLayout.Position(0f, 71, 0f, 0, 1f, 0, 0f, 123));
		this.add(this.lineWidthParameterView(), WindowSpecLayout.Position(0f, 0, 0f, 124, 0f, 289, 0f, 165));

		int lineHeight = this.getFontMetrics(this.font()).getHeight() + 4;
		label = new JLabel(JunSystem.$String("Begin style") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 1, 0f, 173, 0.5f, -1, 0f, 173 + lineHeight));
		this.add(this.beginStyleSquare(), WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight, 0.5f, -1, 0f, 173 + lineHeight * 2));
		this.add(this.beginStyleArrow(), WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight * 2, 0.5f, -1, 0f, 173 + lineHeight * 3));
		this.add(this.beginStyleDiamond(), WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight * 3, 0.5f, -1, 0f, 173 + lineHeight * 4));
		this.add(this.beginStyleCircle(), WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight * 4, 0.5f, -1, 0f, 173 + lineHeight * 5));

		label = new JLabel(JunSystem.$String("End style") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0.5f, 1, 0f, 173, 1f, 0, 0f, 173 + lineHeight));
		this.add(this.endStyleSquare(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight, 1f, 0, 0f, 173 + lineHeight * 2));
		this.add(this.endStyleArrow(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight * 2, 1f, 0, 0f, 173 + lineHeight * 3));
		this.add(this.endStyleDiamond(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight * 3, 1f, 0, 0f, 173 + lineHeight * 4));
		this.add(this.endStyleCircle(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight * 4, 1f, 0, 0f, 173 + lineHeight * 5));

		this.setPreferredSize(new Dimension(290, 173 + lineHeight * 5 + 5));
	}

	/**
	 * Answer the button group of the begin style.
	 *
	 * @return javax.swing.ButtonGroup
	 * @category interface opening
	 */
	public ButtonGroup beginStyle() {
		if (beginArrowStyle == null) {
			beginArrowStyle = new ButtonGroup();
		}
		return beginArrowStyle;
	}

	/**
	 * Answer the checkbox for the begin style as Square.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton beginStyleSquare() {
		if (beginArrowStyleSquare == null) {
			beginArrowStyleSquare = new JRadioButton(JunSystem.$String("Square"), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_SQUARE);
			beginArrowStyleSquare.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_SQUARE);
				}
			});
			this.beginStyle().add(beginArrowStyleSquare);
		}
		return beginArrowStyleSquare;
	}

	/**
	 * Answer the checkbox for the begin style as Arrow.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton beginStyleArrow() {
		if (beginArrowStyleArrow == null) {
			beginArrowStyleArrow = new JRadioButton(JunSystem.$String("Arrow"), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_ARROW);
			beginArrowStyleArrow.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_ARROW);
				}
			});
			this.beginStyle().add(beginArrowStyleArrow);
		}
		return beginArrowStyleArrow;
	}

	/**
	 * Answer the checkbox for the begin style as Diamond.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton beginStyleDiamond() {
		if (beginArrowStyleDiamond == null) {
			beginArrowStyleDiamond = new JRadioButton(JunSystem.$String("Diamond"), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_DIAMOND);
			beginArrowStyleDiamond.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_DIAMOND);
				}
			});
			this.beginStyle().add(beginArrowStyleDiamond);
		}
		return beginArrowStyleDiamond;
	}

	/**
	 * Answer the checkbox for the begin style as Circle.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton beginStyleCircle() {
		if (beginArrowStyleCircle == null) {
			beginArrowStyleCircle = new JRadioButton(JunSystem.$String("Circle"), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_CIRCLE);
			beginArrowStyleCircle.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_CIRCLE);
				}
			});
			this.beginStyle().add(beginArrowStyleCircle);
		}
		return beginArrowStyleCircle;
	}

	/**
	 * Answer the button group of the end style.
	 *
	 * @return javax.swing.ButtonGroup
	 * @category interface opening
	 */
	public ButtonGroup endStyle() {
		if (endArrowStyle == null) {
			endArrowStyle = new ButtonGroup();
		}
		return endArrowStyle;
	}

	/**
	 * Answer the checkbox for the end style as Square.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton endStyleSquare() {
		if (endArrowStyleSquare == null) {
			endArrowStyleSquare = new JRadioButton(JunSystem.$String("Square"), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_SQUARE);
			endArrowStyleSquare.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_SQUARE);
				}
			});
			this.endStyle().add(endArrowStyleSquare);
		}
		return endArrowStyleSquare;
	}

	/**
	 * Answer the checkbox for the end style as Arrow.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton endStyleArrow() {
		if (endArrowStyleArrow == null) {
			endArrowStyleArrow = new JRadioButton(JunSystem.$String("Arrow"), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_ARROW);
			endArrowStyleArrow.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_ARROW);
				}
			});
			this.endStyle().add(endArrowStyleArrow);
		}
		return endArrowStyleArrow;
	}

	/**
	 * Answer the checkbox for the end style as Diamond.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton endStyleDiamond() {
		if (endArrowStyleDiamond == null) {
			endArrowStyleDiamond = new JRadioButton(JunSystem.$String("Diamond"), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_DIAMOND);
			endArrowStyleDiamond.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_DIAMOND);
				}
			});
			this.endStyle().add(endArrowStyleDiamond);
		}
		return endArrowStyleDiamond;
	}

	/**
	 * Answer the checkbox for the end style as Circle.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton endStyleCircle() {
		if (endArrowStyleCircle == null) {
			endArrowStyleCircle = new JRadioButton(JunSystem.$String("Circle"), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_CIRCLE);
			endArrowStyleCircle.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewSwing.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_CIRCLE);
				}
			});
			this.endStyle().add(endArrowStyleCircle);
		}
		return endArrowStyleCircle;
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("beginStyle")) {
			switch (this.getPathModel().pathElement().beginStyle()) {
				case JunPathElement.ARROW_STYLE_SQUARE:
					if (this.beginStyleSquare().isSelected() == false) {
						this.beginStyleSquare().setSelected(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_ARROW:
					if (this.beginStyleArrow().isSelected() == false) {
						this.beginStyleArrow().setSelected(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_DIAMOND:
					if (this.beginStyleDiamond().isSelected() == false) {
						this.beginStyleDiamond().setSelected(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_CIRCLE:
					if (this.beginStyleCircle().isSelected() == false) {
						this.beginStyleCircle().setSelected(true);
					}
					break;
			}
			return;
		}
		if (aSymbol == $("endStyle")) {
			switch (this.getPathModel().pathElement().endStyle()) {
				case JunPathElement.ARROW_STYLE_SQUARE:
					if (this.endStyleSquare().isSelected() == false) {
						this.endStyleSquare().setSelected(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_ARROW:
					if (this.endStyleArrow().isSelected() == false) {
						this.endStyleArrow().setSelected(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_DIAMOND:
					if (this.endStyleDiamond().isSelected() == false) {
						this.endStyleDiamond().setSelected(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_CIRCLE:
					if (this.endStyleCircle().isSelected() == false) {
						this.endStyleCircle().setSelected(true);
					}
					break;
			}
			return;
		}

		super.update_(evt);
	}
}
