package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunRectangularShapeElement;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMap;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModelTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunRectangularShapePropertiesModelTestExamples class
 * 
 *  @author    m-asada
 *  @created   2005/05/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunRectangularShapePropertiesModelTestExamples.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunRectangularShapePropertiesModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunRectangularShapePropertiesModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunDrawingMap aMap = JunDrawingMapModelTestExamples.MapExample1();
		JunDrawingElement[] elements = aMap._componentElements();
		for (int i = elements.length - 1; i >= 0; i--) {
			if (elements[i] instanceof JunRectangularShapeElement) {
				JunRectangularShapePropertiesModel aModel = new JunRectangularShapePropertiesModel((JunRectangularShapeElement) elements[i]);
				aModel.open();
				break;
			}
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunRectangularShapePropertiesModelTestExamples();
	}
}
