package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt;
import jp.co.sra.jun.goodies.parameter.JunParameterViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunRectangularShapePropertiesViewAwt class
 * 
 *  @author    m-asada
 *  @created   2005/05/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunRectangularShapePropertiesViewAwt.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunRectangularShapePropertiesViewAwt extends JunAbstractViewPanel implements JunRectangularShapePropertiesView {
	protected JunColorChoiceViewAwt foregroundColorChoiceView;
	protected JunColorChoiceViewAwt backgroundColorChoiceView;
	protected JunParameterViewAwt lineWidthParameterView;
	protected Checkbox fillView;

	/**
	 * Create a new instance of JunRectangularShapePropertiesViewAwt and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunRectangularShapePropertiesViewAwt() {
		super();
	}

	/**
	 * Create a new instance of JunRectangularShapePropertiesViewAwt and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModel
	 * @category Instance creation
	 */
	public JunRectangularShapePropertiesViewAwt(JunRectangularShapePropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Answer the model as JunRectangularShapePropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesView#getModel()
	 * @category model accessing
	 */
	public JunRectangularShapePropertiesModel getModel() {
		return (JunRectangularShapePropertiesModel) this.model();
	}

	/**
	 * Initialize the JunRectangularShapePropertiesViewAwt.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		foregroundColorChoiceView = null;
		backgroundColorChoiceView = null;
		lineWidthParameterView = null;
		fillView = null;
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		super.release();
		
		this.foregroundColorChoiceView().release();
		this.backgroundColorChoiceView().release();
		this.lineWidthParameterView().release();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		Label label = new Label(JunSystem.$String("Border color") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 0, 0f, 0, 0f, 120, 0f, 30));
		this.add(this.foregroundColorChoiceView(), WindowSpecLayout.Position(0f, 121, 0f, 0, 1f, 0, 0f, 123));
		this.add(this.lineWidthParameterView(), WindowSpecLayout.Position(0f, 0, 0f, 124, 0f, 339, 0f, 165));

		this.add(this.fillView(), WindowSpecLayout.Position(0f, 0, 0f, 180, 0f, 325, 0f, 195));
		Label label2 = new Label(JunSystem.$String("Background color") + " :");
		label2.setFont(this.font());
		this.add(label2, WindowSpecLayout.Position(0f, 0, 0f, 196, 0f, 120, 0f, 196 + 30));
		this.add(this.backgroundColorChoiceView(), WindowSpecLayout.Position(0f, 121, 0f, 196, 1f, 0, 0f, 196 + 123));

		this.setSize(new Dimension(340, 320));
	}

	/**
	 * Answer the receiver's foreground color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt
	 * @category interface opening
	 */
	public JunColorChoiceViewAwt foregroundColorChoiceView() {
		if (foregroundColorChoiceView == null) {
			foregroundColorChoiceView = new JunColorChoiceViewAwt(this.getModel().foregroundColorChoiceModel());
		}
		return foregroundColorChoiceView;
	}

	/**
	 * Answer the receiver's background color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt
	 * @category interface opening
	 */
	public JunColorChoiceViewAwt backgroundColorChoiceView() {
		if (backgroundColorChoiceView == null) {
			backgroundColorChoiceView = new JunColorChoiceViewAwt(this.getModel().backgroundColorChoiceModel());
		}
		return backgroundColorChoiceView;
	}

	/**
	 * Answer the receiver's line width view.
	 *
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterViewAwt
	 * @category interface opening
	 */
	public JunParameterViewAwt lineWidthParameterView() {
		if (lineWidthParameterView == null) {
			lineWidthParameterView = new JunParameterViewAwt(this.getModel().lineWidthParameterModel());
		}
		return lineWidthParameterView;
	}

	/**
	 * Answer the receiver's fill view.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox fillView() {
		if (fillView == null) {
			final JunRectangularShapePropertiesModel theModel = this.getModel();
			fillView = new Checkbox(JunSystem.$String("Fill?"), theModel.isFill());
			fillView.setFont(this.font());
			fillView.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (fillView.getState() != theModel.isFill()) {
						theModel.fill_(fillView.getState());
						theModel.updateFill();
					}
				}
			});
		}
		return fillView;
	}

	/**
	 * Answer the receiver's font.
	 * 
	 * @return java.awt.Font
	 * @category fonts
	 */
	protected Font font() {
		return new Font("dialog", Font.BOLD, 12);
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("foregroundColor") || aSymbol == $("backgroundColor") || aSymbol == $("lineWidth")) {
			return;
		}
		if (aSymbol == $("fill")) {
			if (this.fillView().getState() && this.getModel().rectangularShapeElement().backgroundColor() != null) {
				return;
			}
			if (this.getModel().rectangularShapeElement().backgroundColor() != null) {
				this.fillView().setState(true);
			} else {
				this.fillView().setState(false);
			}
			return;
		}

		super.update_(evt);
	}
}
