package jp.co.sra.jun.goodies.dump;

import java.awt.Font;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import java.awt.BorderLayout;
import javax.swing.JTextArea;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunDumpViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun436 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDumpViewSwing.java,v 8.12 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunDumpViewSwing extends JunAbstractViewJPanel implements JunDumpView {
	protected JTextArea textView;

	/**
	 * Create a new instance of <code>JunDumpViewSwing</code> and initialize it.
	 * 
	 * @param aDumpModel jp.co.sra.jun.goodies.dump.JunDumpModel
	 * @category Instance creation
	 */
	public JunDumpViewSwing(JunDumpModel aDumpModel) {
		super(aDumpModel);
	}

	/**
	 * Answer my model as <code>JunDumpModel</code>.
	 *
	 * @return jp.co.sra.jun.goodies.dump.JunDumpModel
	 * @see jp.co.sra.jun.goodies.dump.JunDumpView#getDumpModel()
	 * @category model accessing
	 */
	public JunDumpModel getDumpModel() {
		return (JunDumpModel) this.model();
	}

	/**
	 * Answer my text view.
	 *
	 * @return javax.swing.JTextArea
	 * @category interface opening
	 */
	public JTextArea textView() {
		if (textView == null) {
			textView = new JTextArea((String) this.getDumpModel().textModel().value());
			textView.setFont(new Font("monospaced", Font.PLAIN, 12));
		}
		return textView;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(new JScrollPane(this.textView()), BorderLayout.CENTER);
		this.setPreferredSize(new Dimension(520, 250));
	}
}
