package jp.co.sra.jun.goodies.fourier;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDiscreteFourierTransformationTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2007/06/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun664 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDiscreteFourierTransformationTestExamples.java,v 8.5 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunDiscreteFourierTransformationTestExamples extends JunTestExamples {

	protected static DecimalFormat FixedPoint10 = new DecimalFormat("0.0000000000");

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		double[] sourceData = ExampleData();
		int sourceSize = sourceData.length;
		JunDiscreteFourierTransformation fourierTransformation = new JunDiscreteFourierTransformation(sourceData);
		double[] realData = fourierTransformation.realData();
		double[] imaginaryData = fourierTransformation.imaginaryData();

		PrintWriter aWriter = null;
		try {
			aWriter = new PrintWriter(new FileWriter("SourceData.csv"));

			for (int i = 0; i < sourceSize; i++) {
				aWriter.print((float) i / sourceSize);
				aWriter.print(", ");
				aWriter.print(FixedPoint10.format(sourceData[i]));
				aWriter.println();
			}
			aWriter.print(1.0f);
			aWriter.print(", ");
			aWriter.print(FixedPoint10.format(sourceData[0]));
			aWriter.println();

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (aWriter != null) {
				aWriter.flush();
				aWriter.close();
			}
		}

		aWriter = null;
		try {
			aWriter = new PrintWriter(new FileWriter("RealData.csv"));

			for (int i = 0; i < sourceSize / 2; i++) {
				aWriter.print((float) i);
				aWriter.print(", ");
				aWriter.print(FixedPoint10.format(realData[i]));
				aWriter.println();
			}
			aWriter.print((float) (sourceSize / 2));
			aWriter.print(", ");
			aWriter.print(FixedPoint10.format(realData[sourceSize / 2]));
			aWriter.println();

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (aWriter != null) {
				aWriter.flush();
				aWriter.close();
			}
		}

		aWriter = null;
		try {
			aWriter = new PrintWriter(new FileWriter("ImaginaryData.csv"));

			for (int i = 0; i < sourceSize / 2; i++) {
				aWriter.print((float) i);
				aWriter.print(", ");
				aWriter.print(FixedPoint10.format(imaginaryData[i]));
				aWriter.println();
			}
			aWriter.print((float) (sourceSize / 2));
			aWriter.print(", ");
			aWriter.print(FixedPoint10.format(imaginaryData[sourceSize / 2]));
			aWriter.println();

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (aWriter != null) {
				aWriter.flush();
				aWriter.close();
			}
		}

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunDiscreteFourierTransformation fourierTransformation = new JunDiscreteFourierTransformation(ExampleData());
		double[] values = fourierTransformation.sourceData();
		Jun2dPoint scaleFactor = new Jun2dPoint(1, 10);
		int rangeValue = 30;
		Point displayPoint = new Point(100, 250);
		Point offsetPoint = new Point(25, 25);
		ArrayList aList = new ArrayList();
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Source Data", displayPoint));

		values = new double[30];
		System.arraycopy(fourierTransformation.realData(), 0, values, 0, 30);
		scaleFactor = new Jun2dPoint(15, 0.04);
		rangeValue = 8000;
		displayPoint.translate(offsetPoint.x, offsetPoint.y);
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Real Data", displayPoint));

		values = new double[30];
		System.arraycopy(fourierTransformation.imaginaryData(), 0, values, 0, 30);
		displayPoint.translate(offsetPoint.x, offsetPoint.y);
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Imaginary Data", displayPoint));

		for (int i = 0; i < aList.size(); i++) {
			((JunApplicationModel) aList.get(i)).closeTogether_(aList);
		}

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunDiscreteFourierTransformation fourierTransformation = new JunDiscreteFourierTransformation(ExampleData());
		double[] values = fourierTransformation.sourceData();
		Jun2dPoint scaleFactor = new Jun2dPoint(1, 10);
		int rangeValue = 30;
		Point displayPoint = new Point(100, 250);
		Point offsetPoint = new Point(25, 25);
		ArrayList aList = new ArrayList();
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Source Data", displayPoint));

		values = new double[30];
		System.arraycopy(fourierTransformation.realData(), 0, values, 0, 30);
		scaleFactor = new Jun2dPoint(15, 0.04);
		rangeValue = 8000;
		displayPoint.translate(offsetPoint.x, offsetPoint.y);
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Real Data", displayPoint));

		values = new double[30];
		System.arraycopy(fourierTransformation.imaginaryData(), 0, values, 0, 30);
		displayPoint.translate(offsetPoint.x, offsetPoint.y);
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Imaginary Data", displayPoint));

		fourierTransformation = new JunDiscreteFourierTransformation(fourierTransformation.realData(), fourierTransformation.imaginaryData());
		values = fourierTransformation.inverseData();
		scaleFactor = new Jun2dPoint(5, 4);
		rangeValue = 75;
		displayPoint.translate(offsetPoint.x, offsetPoint.y);
		aList.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(values, scaleFactor, rangeValue, "Inverse Data", displayPoint));

		for (int i = 0; i < aList.size(); i++) {
			((JunApplicationModel) aList.get(i)).closeTogether_(aList);
		}

		return true;
	}

	/**
	 * Create an example data.
	 * 
	 * @return double[]
	 * @category Examples
	 */
	protected static double[] ExampleData() {
		int sourceSize = 1000;
		double[] sourceData = new double[sourceSize];
		for (int i = 0; i < sourceSize; i++) {
			double cos1 = 6 * Math.cos(12 * 2 * Math.PI * i / sourceSize);
			double sin1 = 4 * Math.sin(5 * 2 * Math.PI * i / sourceSize);
			double cos2 = 3 * Math.cos(24 * 2 * Math.PI * i / sourceSize);
			double sin2 = 2 * Math.sin(10 * 2 * Math.PI * i / sourceSize);
			double v = cos1 + sin1 + cos2 + sin2;
			sourceData[i] = v;
		}
		return sourceData;
	}

	/**
	 * Display the specified values.
	 * 
	 * @param values double[]
	 * @param scaleFactor jp.co.sra.geometry.basic.Jun2dPoint
	 * @param rangeValue double
	 * @param labelString java.lang.String
	 * @param displayPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Examples
	 */
	protected static JunImageDisplayModel ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(double[] values, Jun2dPoint scaleFactor, double rangeValue, String labelString, Point displayPoint) {
		int width = (int) Math.round(values.length * scaleFactor.x());
		int height = (int) Math.round(rangeValue * scaleFactor.y());
		StImage anImage = new StImage(width, height);

		Graphics2D aGraphics = null;
		try {
			aGraphics = (Graphics2D) anImage.image().createGraphics();
			aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

			aGraphics.setColor(Color.white);
			aGraphics.fillRect(0, 0, width, height);

			aGraphics.setColor(Color.gray);
			aGraphics.setStroke(new BasicStroke(1));
			aGraphics.drawLine(0, height / 2, width, height / 2);

			int[] px = new int[values.length];
			int[] py = new int[values.length];
			for (int n = 0; n < values.length; n++) {
				px[n] = (int) Math.round(n * scaleFactor.x());
				py[n] = (int) Math.round(values[n] * -1 * scaleFactor.y() + height / 2);
			}

			aGraphics.setColor(Color.gray);
			aGraphics.setStroke(new BasicStroke(2));
			aGraphics.drawPolyline(px, py, values.length);

			aGraphics.setColor(Color.black);
			for (int n = 0; n < values.length; n++) {
				aGraphics.fillRect(px[n] - 1, py[n] - 1, 3, 3);
			}

		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}

		return JunImageDisplayModel.Show_label_at_(anImage, labelString, displayPoint);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunDiscreteFourierTransformationTestExamples();
	}

}
