package jp.co.sra.jun.goodies.gauge;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunLevelGaugeModel class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/03/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLevelGaugeModel.java,v 8.7 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunLevelGaugeModel extends JunApplicationModel implements StBlockValued {
	protected double value;
	protected double hill;
	protected double dale;
	protected int count;
	protected double average;
	protected double offset;
	protected double maximum;
	protected double minimum;
	protected JunAttributeTable attributes;

	/**
	 * Create a new instance of <code>JunLevelGaugeModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunLevelGaugeModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeModel</code> and initialize it.
	 * 
	 * @param aValue double
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel
	 * @category Instance creation
	 */
	public static JunLevelGaugeModel Initial_(double aValue) {
		return Initial_maximum_minimum_(aValue, Double.NaN, Double.NaN);
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeModel</code> and initialize it.
	 * 
	 * @param aValue double
	 * @param maxValue double
	 * @param minValue double
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel
	 * @category Instance creation
	 */
	public static JunLevelGaugeModel Initial_maximum_minimum_(double aValue, double maxValue, double minValue) {
		JunLevelGaugeModel levelGauge = new JunLevelGaugeModel();
		levelGauge.maximum_(maxValue);
		levelGauge.minimum_(minValue);
		levelGauge.initial_(aValue);
		return levelGauge;
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeModel</code> and initialize it.
	 * 
	 * @param aValue double
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel
	 * @category Instance creation
	 */
	public static JunLevelGaugeModel Value_(double aValue) {
		return Value_maximum_minimum_(aValue, Double.NaN, Double.NaN);
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeModel</code> and initialize it.
	 * 
	 * @param aValue double
	 * @param maxValue double
	 * @param minValue double
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel
	 * @category Instance creation
	 */
	public static JunLevelGaugeModel Value_maximum_minimum_(double aValue, double maxValue, double minValue) {
		JunLevelGaugeModel levelGauge = new JunLevelGaugeModel();
		levelGauge.maximum_(maxValue);
		levelGauge.minimum_(minValue);
		levelGauge.value_(aValue);
		return levelGauge;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		this.reset();
		maximum = Double.NaN;
		minimum = Double.NaN;
		attributes = new JunAttributeTable();
	}

	/**
	 * Answer the receiver's attributes.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAttributeTable
	 * @category accessing
	 */
	public JunAttributeTable attributes() {
		return attributes;
	}

	/**
	 * Answer the receiver's average.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double average() {
		return average;
	}

	/**
	 * Answer the receiver's count.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int count() {
		return count;
	}

	/**
	 * Answer the receiver's dale.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double dale() {
		return dale;
	}

	/**
	 * Answer the receiver's hill.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double hill() {
		return hill;
	}

	/**
	 * Answer the receiver's maximum.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double maximum() {
		return maximum;
	}

	/**
	 * Set the receiver's maximum.
	 * 
	 * @param aValue double
	 * @category accessing
	 */
	public void maximum_(double aValue) {
		maximum = aValue;
	}

	/**
	 * Answer the receiver's minimum.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double middle() {
		return this.minimum() + ((this.maximum() - this.minimum()) / 2);
	}

	/**
	 * Answer the receiver's minimum.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double minimum() {
		return minimum;
	}

	/**
	 * Set the receiver's minimum.
	 * 
	 * @param aValue double
	 * @category accessing
	 */
	public void minimum_(double aValue) {
		minimum = aValue;
	}

	/**
	 * Answer the receiver's range.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double range() {
		return this.maximum() - this.minimum();
	}

	/**
	 * Answer the receiver's total.
	 * 
	 * @return long
	 * @category accessing
	 */
	public double total() {
		return Math.round(this.average() * this.count());
	}

	/**
	 * Answer the receiver's value as Double.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValued#value()
	 * @category accessing
	 */
	public Object value() {
		return new Double(value);
	}

	/**
	 * Set the receiver's value.
	 * 
	 * @param aValue double
	 * @category accessing
	 */
	public void value_(double aValue) {
		value = aValue - offset;
		if (Double.isNaN(this.maximum()) == false) {
			value = Math.min(value, this.maximum());
		}
		if (Double.isNaN(this.minimum()) == false) {
			value = Math.max(value, this.minimum());
		}
		if (Double.isNaN(this.hill())) {
			hill = value;
		} else {
			hill = Math.max(value, this.hill());
		}
		if (Double.isNaN(this.dale())) {
			dale = value;
		} else {
			dale = Math.min(value, this.dale());
		}
		average = (this.total() + value) / (count = count + 1);
		this.changed_($("value"));
	}

	/**
	 * Answer the receiver's value as <code>double</code>.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double _doubleValue() {
		return value;
	}

	/**
	 * Answer the receiver's value as <code>long</code>.
	 * 
	 * @return long
	 * @category accessing
	 */
	public long _longValue() {
		return Math.round(value);
	}

	/**
	 * Compute aBlock.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StBlockValue
	 * @category constructing
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		return new StBlockValue(aBlock, this);
	}

	/**
	 * Initialize the receiver with the specified value.
	 * 
	 * @param aValue double
	 * @category controlling
	 */
	protected void initial_(double aValue) {
		this.offset_(aValue);
		this.value_(aValue);
	}

	/**
	 * Answer the receiver's offset.
	 * 
	 * @return double
	 * @category controlling
	 */
	public double offset() {
		return offset;
	}

	/**
	 * Set the receiver's offset.
	 * 
	 * @param aValue double
	 * @category controlling
	 */
	public void offset_(double aValue) {
		offset = aValue;
	}

	/**
	 * Reset the receiver.
	 * 
	 * @category controlling
	 */
	public void reset() {
		value = Double.NaN;
		hill = Double.NaN;
		dale = Double.NaN;
		count = 0;
		average = Double.NaN;
		offset = 0;
	}

	/**
	 * Reset the receiver's dale.
	 * 
	 * @category controlling
	 */
	public void resetDale() {
		dale = this._doubleValue();
	}

	/**
	 * Reset the receiver's hill.
	 * 
	 * @category controlling
	 */
	public void resetHill() {
		hill = this._doubleValue();
	}

	/**
	 * Resume the receiver with the specified value.
	 * 
	 * @param aValue double
	 * @category controlling
	 */
	public void resume_(double aValue) {
		this.offset_(aValue - this._doubleValue());
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunLevelGaugeViewAwt(this);
		} else {
			return new JunLevelGaugeViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Level Gauge");
	}

	/**
	 * Answer the average color.
	 * 
	 * @return java.awt.Color.
	 * @category preferences
	 */
	public Color averageColor() {
		Color aColor = (Color) this.attributes().at_($("averageColor"));
		if (aColor == null) {
			aColor = Color.green;
			this.attributes().at_put_($("averageColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the average color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void averageColor_(Color colorValue) {
		this.attributes().at_put_($("averageColor"), colorValue);
	}

	/**
	 * Answer the background color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color backgroundColor() {
		Color aColor = (Color) this.attributes().at_($("backgroundColor"));
		if (aColor == null) {
			aColor = StColorValue.VeryLightGray;
			this.attributes().at_put_($("backgroundColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the background color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void backgroundColor_(Color colorValue) {
		this.attributes().at_put_($("backgroundColor"), colorValue);
	}

	/**
	 * Answer the cell size.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int cellSize() {
		Integer anInteger = (Integer) this.attributes().at_($("cellSize"));
		if (anInteger == null) {
			anInteger = new Integer(5);
			this.attributes().at_put_($("cellSize"), anInteger);
		}
		return anInteger.intValue();
	}

	/**
	 * Set the cell size.
	 * 
	 * @param anInteger int
	 * @category preferences
	 */
	public void cellSize_(int anInteger) {
		this.attributes().at_put_($("cellSize"), new Integer(Math.max(anInteger, 3)));
	}

	/**
	 * Answer the cell space.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int cellSpace() {
		Integer anInteger = (Integer) this.attributes().at_($("cellSpace"));
		if (anInteger == null) {
			anInteger = new Integer(1);
			this.attributes().at_put_($("cellSpace"), anInteger);
		}
		return anInteger.intValue();
	}

	/**
	 * Set the cell space.
	 * 
	 * @param anInteger int
	 * @category preferences
	 */
	public void cellSpace_(int anInteger) {
		this.attributes().at_put_($("cellSpace"), new Integer(Math.max(anInteger, 0)));
	}

	/**
	 * Answer the dale color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color daleColor() {
		Color aColor = (Color) this.attributes().at_($("daleColor"));
		if (aColor == null) {
			aColor = Color.blue;
			this.attributes().at_put_($("daleColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the dale color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void daleColor_(Color colorValue) {
		this.attributes().at_put_($("daleColor"), colorValue);
	}

	/**
	 * Answer the edge color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color edgeColor() {
		Color aColor = (Color) this.attributes().at_($("edgeColor"));
		if (aColor == null) {
			aColor = Color.white;
			this.attributes().at_put_($("edgeColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the edge color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void edgeColor_(Color colorValue) {
		this.attributes().at_put_($("edgeColor"), colorValue);
	}

	/**
	 * Answer the frame color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color frameColor() {
		Color aColor = (Color) this.attributes().at_($("frameColor"));
		if (aColor == null) {
			aColor = StColorValue.LightGray;
			this.attributes().at_put_($("frameColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the frame color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void frameColor_(Color colorValue) {
		this.attributes().at_put_($("frameColor"), colorValue);
	}

	/**
	 * Answer the gauge width.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int gaugeWidth() {
		Integer anInteger = (Integer) this.attributes().at_($("gaugeWidth"));
		if (anInteger == null) {
			anInteger = new Integer(16);
			this.attributes().at_put_($("gaugeWidth"), anInteger);
		}
		return anInteger.intValue();
	}

	/**
	 * Set the gauge width.
	 * 
	 * @param anInteger int
	 * @category preferences
	 */
	public void gaugeWidth_(int anInteger) {
		int roundValue = Math.round(anInteger / 2f) * 2;
		this.attributes().at_put_($("gaugeWidth"), new Integer(Math.max(roundValue, 2)));
	}

	/**
	 * Answer the hill color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color hillColor() {
		Color aColor = (Color) this.attributes().at_($("hillColor"));
		if (aColor == null) {
			aColor = Color.red;
			this.attributes().at_put_($("hillColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the hill color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void hillColor_(Color colorValue) {
		this.attributes().at_put_($("hillColor"), colorValue);
	}

	/**
	 * Answer true if the receiver is horizontal gauge, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean horizontalGauge() {
		return !this.verticalGauge();
	}

	/**
	 * Set the horizontal gauge.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void horizontalGauge_(boolean aBoolean) {
		this.verticalGauge_(!aBoolean);
	}

	/**
	 * Answer true if the receiver is rainbow color, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean rainbowColor() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("rainbowColor"));
		if (aBoolean == null) {
			aBoolean = Boolean.FALSE;
			this.attributes().at_put_($("rainbowColor"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the rainbow color.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void rainbowColor_(boolean aBoolean) {
		this.attributes().at_put_($("rainbowColor"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver reverse direction, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean reverseDirection() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("reverseDirection"));
		if (aBoolean == null) {
			aBoolean = Boolean.FALSE;
			this.attributes().at_put_($("reverseDirection"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver reverse direction.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void reverseDirection_(boolean aBoolean) {
		this.attributes().at_put_($("reverseDirection"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show average, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showAverage() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showAverage"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("showAverage"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the reciver show average.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showAverage_(boolean aBoolean) {
		this.attributes().at_put_($("showAverage"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show background, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showBackground() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showBackground"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("showBackground"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver show background.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showBackground_(boolean aBoolean) {
		this.attributes().at_put_($("showBackground"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show dale, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showDale() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showDale"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("showDale"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver show dale.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showDale_(boolean aBoolean) {
		this.attributes().at_put_($("showDale"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show edge, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showEdge() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showEdge"));
		if (aBoolean == null) {
			aBoolean = Boolean.FALSE;
			this.attributes().at_put_($("showEdge"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver show edge.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showEdge_(boolean aBoolean) {
		this.attributes().at_put_($("showEdge"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show frame, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showFrame() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showFrame"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("showFrame"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver show frame.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showFrame_(boolean aBoolean) {
		this.attributes().at_put_($("showFrame"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show hill, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showHill() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showHill"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("showHill"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver show hill.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showHill_(boolean aBoolean) {
		this.attributes().at_put_($("showHill"), new Boolean(aBoolean));
	}

	/**
	 * Answer true if the receiver show value, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showValue() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("showValue"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("showValue"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the receiver show value.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showValue_(boolean aBoolean) {
		this.attributes().at_put_($("showValue"), new Boolean(aBoolean));
	}

	/**
	 * Answer the edge color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color valueColor() {
		Color aColor = (Color) this.attributes().at_($("valueColor"));
		if (aColor == null) {
			aColor = StColorValue.DarkGray;
			this.attributes().at_put_($("valueColor"), aColor);
		}
		return aColor;
	}

	/**
	 * Set the edge color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void valueColor_(Color colorValue) {
		this.attributes().at_put_($("valueColor"), colorValue);
	}

	/**
	 * Answer true if the receiver is vertical gauge, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean verticalGauge() {
		Boolean aBoolean = (Boolean) this.attributes().at_($("verticalGauge"));
		if (aBoolean == null) {
			aBoolean = Boolean.TRUE;
			this.attributes().at_put_($("verticalGauge"), aBoolean);
		}
		return aBoolean.booleanValue();
	}

	/**
	 * Set the vertical gauge.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void verticalGauge_(boolean aBoolean) {
		this.attributes().at_put_($("verticalGauge"), new Boolean(aBoolean));
	}
}
