package jp.co.sra.jun.goodies.image.streams;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.co.sra.smalltalk.StImage;

/**
 * JunDefaultImageStream class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2001/04/18 (by Mitsuhiro Asada)
 *  @updated   2005/08/15 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDefaultImageStream.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunDefaultImageStream extends JunImageStream {
	/**
	 * Constructor with an input stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.InputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(InputStream stream) throws IOException {
		return On_(new JunDefaultImageStream(), stream);
	}

	/**
	 * Constructor with an output stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(OutputStream stream) throws IOException {
		throw new IOException("could not save image");
	}

	/**
	 * Read the image from the input stream. (used Java core API - toolkit)
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public StImage nextImage() throws IOException {
		if (inStream != null) {
			Frame frame = new Frame();
			Toolkit toolkit = frame.getToolkit();
			Image image = toolkit.createImage(this.readInputStream());
			MediaTracker tracker = new MediaTracker(frame);
			tracker.addImage(image, 0);
			try {
				tracker.waitForAll();
			} catch (InterruptedException exception) {
				throw new IOException("image load interrupted.");
			}
			int status = tracker.statusAll(false);
			if (((status & MediaTracker.ABORTED) != 0) || ((status & MediaTracker.ERRORED) != 0)) {
				throw new IOException("image load interrupted.");
			}
			image.flush();
			imageObject = new StImage(image);
		}
		return imageObject;
	}

	/**
	 * Write the image on output stream. (used Java core API - toolkit)
	 * 
	 * @param newImage jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public void nextPutImage_(StImage newImage) throws IOException {
		throw new IOException("could not save image");
	}

	/**
	 * Set the output stream.
	 * 
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category initialize-release
	 */
	protected void on_(OutputStream stream) throws IOException {
		throw new IOException("could not save image");
	}

	/**
	 * Read the input stream.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category stream access
	 */
	private byte[] readInputStream() throws IOException {
		byte[] bytes = null;
		if (inStream != null) {
			ByteArrayOutputStream byteStream = null;
			BufferedOutputStream bufferedStream = null;
			try {
				byteStream = new ByteArrayOutputStream();
				bufferedStream = new BufferedOutputStream(byteStream);
				byte[] buffer = new byte[5120];
				int size;
				while ((size = inStream.read(buffer, 0, buffer.length)) != -1) {
					bufferedStream.write(buffer, 0, size);
				}
				bufferedStream.flush();
				bytes = byteStream.toByteArray();
			} finally {
				if (bufferedStream != null) {
					bufferedStream.close();
					bufferedStream = null;
				}
				if (byteStream != null) {
					byteStream.close();
					byteStream = null;
				}
			}
		}
		return bytes;
	}

	/**
	 * Answer the receiver's image file extension.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.jun.goodies.image.streams.JunImageStream#defaultImageExtension()
	 * @category defaults
	 */
	public String defaultImageExtension() {
		return "*";
	}
}
