package jp.co.sra.jun.goodies.image.support;

import java.awt.TextArea;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunImageToAsciiViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2000/12/13 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/12/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageToAsciiViewAwt.java,v 8.12 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageToAsciiViewAwt extends JunAbstractViewPanel implements JunImageToAsciiView {

	protected TextArea textArea;

	/**
	 * Create a new instance of JunImageToAsciiViewAwt and initialize it.
	 *
	 * @param anImageToAscii jp.co.sra.jun.goodies.image.support.JunImageToAscii
	 * @category Instance creation
	 */
	public JunImageToAsciiViewAwt(JunImageToAscii anImageToAscii) {
		super(anImageToAscii);
	}

	/**
	 * Build the component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.textArea(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		this.setSize(600, 400);
	}

	/**
	 * Answer my model as JunImageToAscii.
	 *
	 * @return jp.co.sra.jun.goodies.image.support.JunImageToAscii
	 * @category model accessing
	 */
	public JunImageToAscii getImageToAscii() {
		return (JunImageToAscii) this.model();
	}

	/**
	 * Answer the text area.
	 * 
	 * @return java.awt.TextArea
	 * @category user interface
	 */
	protected TextArea textArea() {
		if (textArea == null) {
			textArea = new TextArea("", 0, 0, TextArea.SCROLLBARS_VERTICAL_ONLY);
			textArea.setFont(this.getImageToAscii().font());

			this.getImageToAscii().textModel().compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					textArea().setText(anObject.toString());
					return null;
				}
			});
		}

		return textArea;
	}

}
