package jp.co.sra.jun.goodies.itemlist;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunChoiceListDialogTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/15 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChoiceListDialogTestExamples.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunChoiceListDialogTestExamples extends JunItemListDialogTestExamples {
	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunChoiceListDialogTestExamples();
	}

	/**
	 * Example1 : test for a JunChoiceListDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Object[] answer = JunChoiceListDialog.Request_labels_checks_(JunSystem.$String("Choose items."), _StringArray, JunItemListTestExamples._CheckArray);
		_PrintObjects_(answer);
		return true;
	}

	/**
	 * Example2 : test for a JunChoiceListDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Object[] answer = JunChoiceListDialog.Request_labels_checks_onAccept_onCancel_(JunSystem.$String("Choose items."), _StringArray, JunItemListTestExamples._CheckArray, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunItemListModel model = (JunItemListModel) anObject;
				System.out.print(JunSystem.$String("Accept button was pressed."));
				System.out.print(" \t");
				_PrintObjects_(model.value());
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunItemListModel model = (JunItemListModel) anObject;
				System.out.print(JunSystem.$String("Cancel button was pressed."));
				System.out.print(" \t");
				_PrintObjects_(model.value());
				return Boolean.TRUE;
			}
		});
		_PrintObjects_(answer);
		return true;
	}

	/**
	 * Example3 : test for a JunChoiceListDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Object[] answer = JunChoiceListDialog.Request_labels_checks_locks_(JunSystem.$String("Choose items."), _StringArray, JunItemListTestExamples._CheckArray, JunItemListTestExamples._LockArray);
		_PrintObjects_(answer);
		return true;
	}
}
