package jp.co.sra.jun.goodies.itemlist;

import java.io.*;

/**
 * JunItemListObject class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunItemListObject.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunItemListObject extends JunOrderListObject {
	protected boolean checkMark;
	protected boolean checkLock;

	/**
	 * Create a new instance of JunItemListObject.
	 * 
	 * @category Instance creation
	 */
	public JunItemListObject() {
		super();
	}

	/**
	 * Create a new instance of JunItemListObject.
	 * 
	 * @param aString java.lang.String
	 * @category Instance creation
	 */
	public JunItemListObject(String aString) {
		super(aString);
	}

	/**
	 * Create a new instance of JunItemListObject.
	 * 
	 * @param aString java.lang.String
	 * @param aBoolean boolean
	 * @category Instance creation
	 */
	public JunItemListObject(String aString, boolean aBoolean) {
		super(aString);
		this.checkMark_(aBoolean);
	}

	/**
	 * Create a new instance of JunItemListObject.
	 * 
	 * @param aString java.lang.String
	 * @param checkBoolean boolean
	 * @param lockBoolean boolean
	 * @category Instance creation
	 */
	public JunItemListObject(String aString, boolean checkBoolean, boolean lockBoolean) {
		super(aString);
		this.checkMark_(checkBoolean);
		this.checkLock_(lockBoolean);
	}

	/**
	 * Initialize this object.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		checkMark = false;
		checkLock = false;
	}

	/**
	 * Get the check lock flag.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean checkLock() {
		return checkLock;
	}

	/**
	 * Get the check mark flag.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean checkMark() {
		return checkMark;
	}

	/**
	 * Set the check lock flag.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void checkLock_(boolean aBoolean) {
		checkLock = aBoolean;
	}

	/**
	 * Set the check mark flag.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void checkMark_(boolean aBoolean) {
		if (this.checkLock()) {
			return;
		}
		checkMark = aBoolean;
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(this.getClass().getName());
		aWriter.write(" (");
		aWriter.write(this.itemString());
		aWriter.write(" ");
		aWriter.write(String.valueOf(this.checkMark()));
		aWriter.write(" ");
		aWriter.write(String.valueOf(this.checkLock()));
		aWriter.write(")");
	}
}
