package jp.co.sra.jun.goodies.itemlist;

import java.awt.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOrderListDialog class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListDialog.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOrderListDialog extends StSimpleDialog {
	protected JunOrderListModel itemListModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Create a new instance of JunOrderListDialog.
	 * 
	 * @category Instance creation
	 */
	public JunOrderListDialog() {
		super();
	}

	/**
	 * Open a JunOrderListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @category Utilities
	 */
	public static Object[] Request_labels_(String messageString, String[] stringCollection) {
		return Request_labels_onAccept_onCancel_(messageString, stringCollection, null, null);
	}

	/**
	 * Open a JunOrderListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Utilities
	 */
	public static Object[] Request_labels_onAccept_onCancel_(String messageString, String[] stringCollection, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunOrderListDialog itemListDialog = new JunOrderListDialog();
		itemListDialog.itemListModel_(new JunOrderListModel(stringCollection));

		Dialog dialog = itemListDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			itemListDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			itemListDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);

		if (itemListDialog.accept()._booleanValue()) {
			return itemListDialog.itemListModel().value();
		} else {
			return null;
		}
	}

	/**
	 * Initialize this object.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		itemListModel = null;
		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Get the new order list model.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListModel
	 * @category accessing
	 */
	public JunOrderListModel itemListModel() {
		return itemListModel;
	}

	/**
	 * Set the new order list model.
	 * 
	 * @param anItemListModel jp.co.sra.jun.goodies.itemlist.JunOrderListModel
	 * @category accessing
	 */
	public void itemListModel_(JunOrderListModel anItemListModel) {
		itemListModel = anItemListModel;
	}

	/**
	 * Set the new accept block.
	 *
	 * @param newAcceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void acceptBlock_(StBlockClosure newAcceptBlock) {
		acceptBlock = newAcceptBlock;
	}

	/**
	 * Set the new cancel block.
	 *
	 * @param newCancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void cancelBlock_(StBlockClosure newCancelBlock) {
		cancelBlock = newCancelBlock;
	}

	/**
	 * Called when an accept button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			return ((Boolean) acceptBlock.value_(this.itemListModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Called when a cancel button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			return ((Boolean) cancelBlock.value_(this.itemListModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category viewing
	 */
	protected String windowTitle() {
		return JunSystem.$String("Order List Dialog");
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunOrderListDialogViewAwt(this);
		} else {
			return new JunOrderListDialogViewSwing(this);
		}
	}
}
