package jp.co.sra.jun.goodies.lisp;

import java.awt.Color;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;
import jp.co.sra.smalltalk.menu.StPopupMenuViewAwt;

import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunLispInterpreterViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/05/07 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispInterpreterViewAwt.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLispInterpreterViewAwt extends JunAbstractViewPanel implements JunLispInterpreterView {

	protected TextArea textValueView;
	protected TextArea textCollectorView;

	/**
	 * Create a new instance of JunLispInterpreterViewAwt and initialize it.
	 *
	 * @param aLispInterpreter jp.co.sra.jun.goodies.lisp.JunLispInterpreter
	 */
	public JunLispInterpreterViewAwt(JunLispInterpreter aLispInterpreter) {
		super(aLispInterpreter);
	}

	/**
	 * Answer my model as JunLispInterpreter.
	 *
	 * @return jp.co.sra.jun.goodies.lisp.JunLispInterpreter
	 */
	public JunLispInterpreter getLispInterpreter() {
		return (JunLispInterpreter) this.model();
	}

	/**
	 * Answer the selected text to 'do it'.
	 *
	 * @return java.lang.String
	 */
	public String getSelectedText() {
		return this.textValueView().getSelectedText();
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.textValueView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0.3f, -1));
		this.add(this.textCollectorView(), WindowSpecLayout.Position(0f, 1, 0.3f, 0, 1f, -1, 1f, -1));
		this.setSize(350, 400);
	}

	/**
	 * Answer the view of my text collector.
	 *
	 * @return java.awt.TextArea
	 */
	protected TextArea textCollectorView() {
		if (textCollectorView == null) {
			textCollectorView = new TextArea("", 0, 0, TextArea.SCROLLBARS_VERTICAL_ONLY);
			textCollectorView.setBackground(Color.lightGray);

			ByteArrayOutputStream aByteArrayOutputStream = new ByteArrayOutputStream() {
				public synchronized void write(byte b[], int off, int len) {
					super.write(b, off, len);
					textCollectorView.append(new String(b, off, len));
				}
			};
			this.getLispInterpreter().textCollector_(new PrintStream(aByteArrayOutputStream));
		}
		return textCollectorView;
	}

	/**
	 * Answer the view of my text value.
	 *
	 * @return java.awt.TextArea
	 */
	protected TextArea textValueView() {
		if (textValueView == null) {
			textValueView = new TextArea((String) this.getLispInterpreter().textValue().value(), 0, 0, TextArea.SCROLLBARS_VERTICAL_ONLY);

			StPopupMenu aPopupMenu = new StPopupMenu();
			aPopupMenu.add(new StMenuItem("do it", new MenuPerformer(this.getLispInterpreter(), "doIt", this)));

			final PopupMenu aPopupMneu = new StPopupMenuViewAwt(aPopupMenu).toPopupMenu();
			textValueView.add(aPopupMneu);
			textValueView.addMouseListener(new MouseAdapter() {
				public void mousePressed(MouseEvent e) {
					if (e.isMetaDown() || e.isPopupTrigger()) {
						aPopupMneu.show(textValueView, e.getX(), e.getY());
					}
				}
			});

			this.getLispInterpreter().textValue().compute_(new StBlockClosure() {
				public Object value_(Object newValue) {
					textValueView.setText((String) newValue);
					return null;
				}
			});
		}
		return textValueView;
	}
}
