package jp.co.sra.jun.goodies.meter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunAbstractGaugeMeter class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/03/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractGaugeMeter.java,v 8.7 2008/02/20 06:31:49 nisinaka Exp $
 */
public abstract class JunAbstractGaugeMeter extends JunApplicationModel {
	public static final int MaximumNumberOfGauges = 100;

	/**
	 * Create a new instance of <code>JunAbstractGaugeMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @category Instance creation
	 */
	public JunAbstractGaugeMeter(int numberOfGauges) {
		this(numberOfGauges, 0, 1, 0);
	}

	/**
	 * Create a new instance of <code>JunAbstractGaugeMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @param value double
	 * @param maximum double
	 * @param minimum double
	 * @category Instance creation
	 */
	public JunAbstractGaugeMeter(int numberOfGauges, double value, double maximum, double minimum) {
		super();

		double[] valueCollection = new double[numberOfGauges];
		Arrays.fill(valueCollection, value);
		double[] maximumCollection = new double[numberOfGauges];
		Arrays.fill(maximumCollection, maximum);
		double[] minimumCollection = new double[numberOfGauges];
		Arrays.fill(minimumCollection, minimum);
		this.initialize_values_maximumx_minimums_(numberOfGauges, valueCollection, maximumCollection, minimumCollection);
	}

	/**
	 * Create a new instance of <code>JunAbstractGaugeMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @param valueCollection double[]
	 * @param maximumCollection double[]
	 * @param minimumCollection double[]
	 * @category Instance creation
	 */
	public JunAbstractGaugeMeter(int numberOfGauges, double[] valueCollection, double[] maximumCollection, double[] minimumCollection) {
		super();
		this.initialize_values_maximumx_minimums_(numberOfGauges, valueCollection, maximumCollection, minimumCollection);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		this.initialize_values_maximumx_minimums_(0, new double[0], new double[0], new double[0]);
	}

	/**
	 * Initialize the receiver with the specified values.
	 * 
	 * @param numberOfGauges int
	 * @param valueCollection double[]
	 * @param maximumCollection double[]
	 * @param minimumCollection double[]
	 * @category initialize-release
	 */
	protected abstract void initialize_values_maximumx_minimums_(int numberOfGauges, double[] valueCollection, double[] maximumCollection, double[] minimumCollection);

	/**
	 * Answer the receiver's averages.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] averages() {
		JunLevelGaugeModel[] gauges = this.gauges();
		double[] values = new double[gauges.length];
		for (int i = 0; i < gauges.length; i++) {
			values[i] = gauges[i].average();
		}
		return values;
	}

	/**
	 * Answer the receiver's dales.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] dales() {
		JunLevelGaugeModel[] gauges = this.gauges();
		double[] values = new double[gauges.length];
		for (int i = 0; i < gauges.length; i++) {
			values[i] = gauges[i].dale();
		}
		return values;
	}

	/**
	 * Answer the receiver's gauges
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel[]
	 * @category accessing
	 */
	public abstract JunLevelGaugeModel[] gauges();

	/**
	 * Answer the receiver's hills.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] hills() {
		JunLevelGaugeModel[] gauges = this.gauges();
		double[] values = new double[gauges.length];
		for (int i = 0; i < gauges.length; i++) {
			values[i] = gauges[i].hill();
		}
		return values;
	}

	/**
	 * Answer the receiver's maximum.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double maximum() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().maximum();
		}

		return this.gauges()[0].maximum();
	}

	/**
	 * Set the receiver's maximum.
	 * 
	 * @param aValue double
	 * @category accessing
	 */
	public void maximum_(double aValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].maximum_(aValue);
		}
	}

	/**
	 * Answer the receiver's minimum.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double minimum() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().minimum();
		}

		return this.gauges()[0].minimum();
	}

	/**
	 * Set the receiver's minimum.
	 * 
	 * @param aValue double
	 * @category accessing
	 */
	public void minimum_(double aValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].minimum_(aValue);
		}
	}

	/**
	 * Answer the receiver's range.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double range() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().range();
		}

		return this.gauges()[0].range();
	}

	/**
	 * Answer the receiver's totals.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] totals() {
		JunLevelGaugeModel[] gauges = this.gauges();
		double[] values = new double[gauges.length];
		for (int i = 0; i < gauges.length; i++) {
			values[i] = gauges[i].total();
		}
		return values;
	}

	/**
	 * Answer the receiver's values.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] values() {
		JunLevelGaugeModel[] gauges = this.gauges();
		double[] values = new double[gauges.length];
		for (int i = 0; i < gauges.length; i++) {
			values[i] = gauges[i]._doubleValue();
		}
		return values;
	}

	/**
	 * Answer the receiver's averages.
	 * 
	 * @param valueCollection double[]
	 * @throws java.lang.RuntimeException
	 * @category accessing
	 */
	public void values_(double[] valueCollection) {
		JunLevelGaugeModel[] gauges = this.gauges();
		if (gauges.length != valueCollection.length) {
			throw new RuntimeException("collection sizes do not match.");
		}
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].value_(valueCollection[i]);
		}
	}

	/**
	 * Answer the receiver's averages.
	 * 
	 * @param valueCollection java.lang.Number[]
	 * @throws java.lang.RuntimeException
	 * @category accessing
	 */
	public void values_(Number[] valueCollection) {
		JunLevelGaugeModel[] gauges = this.gauges();
		if (gauges.length != valueCollection.length) {
			throw new RuntimeException("collection sizes do not match.");
		}
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].value_(valueCollection[i].doubleValue());
		}
	}

	/**
	 * Answer the receiver's default gauge class.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel
	 * @throws java.lang.RuntimeException
	 * @category defaults
	 */
	public JunLevelGaugeModel defaultLevelGauge() {
		return (JunLevelGaugeModel) _New(this.defaultLevelGaugeClass());
	}

	/**
	 * Answer the receiver's default gauge class.
	 * 
	 * @return java.lang.Class
	 * @category defaults
	 */
	public Class defaultLevelGaugeClass() {
		return JunLevelGaugeModel.class;
	}

	/**
	 * Evaluate aBlock with each of the values of the receiver as the argument.
	 * Collect the resulting values into a collection that is like the receiver.
	 * Answer the new collection.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.util.Collection
	 * @category enumerating
	 */
	public Collection collect_(final StBlockClosure aBlock) {
		final Collection newCollection = new ArrayList();
		this.do_(new StBlockClosure() {
			public Object value_(Object each) {
				newCollection.add(aBlock.value_(each));
				return null;
			}
		});
		return newCollection;
	}

	/**
	 * Evaluate the specified block closure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public Object do_(final StBlockClosure aBlock) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			Object result = aBlock.value_(gauges[i]);
			if (result != null) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Accumulate a running value associated with evaluating the argument,
	 * binaryBlock, with the current value and the receiver as block arguments.
	 * The initial value is the value of the argument, thisValue.
	 * 
	 * @param thisValue int
	 * @param binaryBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return int
	 * @category enumerating
	 */
	public int inject_into_(final int thisValue, final StBlockClosure binaryBlock) {
		final StValueHolder nextValue = new StValueHolder(thisValue);
		this.do_(new StBlockClosure() {
			public Object value_(Object each) {
				nextValue.value_(binaryBlock.value_value_(new Integer(nextValue._intValue()), each));
				return null;
			}
		});
		return nextValue._intValue();
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument.
	 * Collect into a new collection like the receiver, only those elements
	 * for which aBlock evaluates to false.  Answer the new collection.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.util.Collection
	 * @category enumerating
	 */
	public Collection reject_(final StBlockClosure aBlock) {
		return this.select_(new StBlockClosure() {
			public Object value_(Object element) {
				return aBlock.value_(element);
			}
		});
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument. 
	 * Collect into a new collection like the receiver, only those elements
	 * for which aBlock evaluates to true.  Answer the new collection.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.util.Collection
	 * @category enumerating
	 */
	public Collection select_(final StBlockClosure aBlock) {
		final Collection newCollection = new ArrayList();
		this.do_(new StBlockClosure() {
			public Object value_(Object each) {
				Boolean aBoolean = (Boolean) aBlock.value_(each);
				if (aBoolean != null && aBoolean.booleanValue() == true) {
					newCollection.add(each);
				}
				return null;
			}
		});
		return newCollection;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Level Meter");
	}

	/**
	 * Answer the receiver's average color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color averageColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().averageColor();
		}

		return this.gauges()[0].averageColor();
	}

	/**
	 * Set the receiver's average color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void averageColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].averageColor_(colorValue);
		}
	}

	/**
	 * Answer the receiver's background color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color backgroundColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().backgroundColor();
		}

		return this.gauges()[0].backgroundColor();
	}

	/**
	 * Set the receiver's background color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void backgroundColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].backgroundColor_(colorValue);
		}
	}

	/**
	 * Answer the receiver's cell size.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int cellSize() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().cellSize();
		}

		return this.gauges()[0].cellSize();
	}

	/**
	 * Set the receiver's cell size.
	 * 
	 * @param anInteger int
	 * @category preferences
	 */
	public void cellSize_(int anInteger) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].cellSize_(anInteger);
		}
	}

	/**
	 * Answer the receiver's cell space.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int cellSpace() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().cellSpace();
		}

		return this.gauges()[0].cellSpace();
	}

	/**
	 * Set the receiver's cell space.
	 * 
	 * @param anInteger int
	 * @category preferences
	 */
	public void cellSpace_(int anInteger) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].cellSpace_(anInteger);
		}
	}

	/**
	 * Answer the receiver's dale color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color daleColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().daleColor();
		}

		return this.gauges()[0].daleColor();
	}

	/**
	 * Set the receiver's dale color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void daleColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].daleColor_(colorValue);
		}
	}

	/**
	 * Answer the receiver's edge color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color edgeColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().edgeColor();
		}

		return this.gauges()[0].edgeColor();
	}

	/**
	 * Set the receiver's edge color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void edgeColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].edgeColor_(colorValue);
		}
	}

	/**
	 * Answer the receiver's frame color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color frameColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().frameColor();
		}

		return this.gauges()[0].frameColor();
	}

	/**
	 * Set the receiver's frame color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void frameColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].frameColor_(colorValue);
		}
	}

	/**
	 * Answer the receiver's gauge width.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int gaugeWidth() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().gaugeWidth();
		}

		return this.gauges()[0].gaugeWidth();
	}

	/**
	 * Set the receiver's gauge width.
	 * 
	 * @param anInteger int
	 * @category preferences
	 */
	public void gaugeWidth_(int anInteger) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].gaugeWidth_(anInteger);
		}
	}

	/**
	 * Answer the receiver's hill color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color hillColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().hillColor();
		}

		return this.gauges()[0].hillColor();
	}

	/**
	 * Set the receiver's hill color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void hillColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].hillColor_(colorValue);
		}
	}

	/**
	 * Answer true if the receiver is horizontal gauge, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean horizontalGauge() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().horizontalGauge();
		}

		return this.gauges()[0].horizontalGauge();
	}

	/**
	 * Set the receiver's horizontal gauge.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void horizontalGauge_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].horizontalGauge_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver is rainbow color, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean rainbowColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().rainbowColor();
		}

		return this.gauges()[0].rainbowColor();
	}

	/**
	 * Set the receiver's rainbow color.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void rainbowColor_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].rainbowColor_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver reverse direction, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean reverseDirection() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().reverseDirection();
		}

		return this.gauges()[0].reverseDirection();
	}

	/**
	 * Set the receiver's reverse direction.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void reverseDirection_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].reverseDirection_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show average, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showAverage() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showAverage();
		}

		return this.gauges()[0].showAverage();
	}

	/**
	 * Set the receiver show average.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showAverage_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showAverage_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show background, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showBackground() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showBackground();
		}

		return this.gauges()[0].showBackground();
	}

	/**
	 * Set the receiver show background.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showBackground_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showBackground_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show dale, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showDale() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showDale();
		}

		return this.gauges()[0].showDale();
	}

	/**
	 * Set the receiver show dale.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showDale_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showDale_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show edge, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showEdge() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showEdge();
		}

		return this.gauges()[0].showEdge();
	}

	/**
	 * Set the receiver show edge.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showEdge_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showEdge_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show frame, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showFrame() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showFrame();
		}

		return this.gauges()[0].showFrame();
	}

	/**
	 * Set the receiver show frame.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showFrame_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showFrame_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show hill, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showHill() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showHill();
		}

		return this.gauges()[0].showHill();
	}

	/**
	 * Set the receiver show hill.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showHill_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showHill_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver show value, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean showValue() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().showValue();
		}

		return this.gauges()[0].showValue();
	}

	/**
	 * Set the receiver show value.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void showValue_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].showValue_(aBoolean);
		}
	}

	/**
	 * Answer the receiver's value color.
	 * 
	 * @return java.awt.Color
	 * @category preferences
	 */
	public Color valueColor() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().valueColor();
		}

		return this.gauges()[0].valueColor();
	}

	/**
	 * Set the receiver's value color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category preferences
	 */
	public void valueColor_(Color colorValue) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].valueColor_(colorValue);
		}
	}

	/**
	 * Answer true if the receiver is vertical gauge, otherwise false.
	 * 
	 * @return boolean
	 * @category preferences
	 */
	public boolean verticalGauge() {
		if (this.isEmpty()) {
			return this.defaultLevelGauge().verticalGauge();
		}

		return this.gauges()[0].verticalGauge();
	}

	/**
	 * Set the receiver's vertical gauge.
	 * 
	 * @param aBoolean boolean
	 * @category preferences
	 */
	public void verticalGauge_(boolean aBoolean) {
		JunLevelGaugeModel[] gauges = this.gauges();
		for (int i = 0; i < gauges.length; i++) {
			gauges[i].verticalGauge_(aBoolean);
		}
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmpty() {
		JunLevelGaugeModel[] gauges = this.gauges();
		return gauges == null || gauges.length == 0;
	}
}
