package jp.co.sra.jun.goodies.movie.framework;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;

import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StModel;

import jp.co.sra.qt4jun.JunQTMovie;
import jp.co.sra.qt4jun.JunQTMovieFactory;
import jp.co.sra.qt4jun.JunQTPort;

import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMovieHandle class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2001/01/12 (by NISHIHARA Satoshi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMovieHandle.java,v 8.12 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMovieHandle extends StModel {
	protected File filename;
	protected JunQTMovie movie;
	protected Dimension originalExtent;
	protected boolean dontRecover;

	/**
	 * ConvertToRelative_
	 * 
	 * @param aFilename java.lang.String
	 * @return java.lang.String
	 * @deprecated since Jun500
	 * @category Utilities
	 */
	public static String ConvertToRelative_(String aFilename) {
		return aFilename;
	}

	/**
	 * get aJunMovieHandle with file.
	 * 
	 * @param aFilename java.io.File
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMovieHandle
	 * @category Instance creation
	 */
	public static JunMovieHandle Filename_(File aFilename) {
		if ((aFilename == null) || !aFilename.exists()) {
			return null;
		}

		JunMovieHandle aMovieHandle = new JunMovieHandle();
		aMovieHandle.setFilename_(aFilename);
		aMovieHandle.setMovie_(JunQTMovieFactory.openMovie(aFilename));

		return aMovieHandle;
	}

	/**
	 * get aJunMovieHandle with file.
	 * 
	 * @param aFilename java.lang.String
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMovieHandle
	 * @category Instance creation
	 */
	public static JunMovieHandle Filename_(String aFilename) {
		return JunMovieHandle.Filename_(new File(aFilename));
	}

	/**
	 * open the movie and return the movie handle.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMovieHandle
	 * @category Instance creation
	 */
	public static JunMovieHandle OpenMovie() {
		JunMovieHandle movieHandle = new JunMovieHandle();
		movieHandle.openMovie();

		return movieHandle;
	}

	/**
	 * private.
	 * 
	 * @return java.lang.Object
	 * @deprecated since Jun500
	 * @category private
	 */
	public Object _interface() {
		return null;
	}

	/**
	 * set the movie to active/inactive.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void active_(boolean aBoolean) {
		if (this.hasMovie() == true) {
			movie.setActive(aBoolean);
		}
	}

	/**
	 * get the image from the movie.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category converting
	 */
	public StImage asImage() {
		Image anImage = this.toImage();
		return (anImage == null) ? null : new StImage(anImage);
	}

	/**
	 * get the image from the movie at the given time value.
	 * 
	 * @param timeValue int
	 * @return jp.co.sra.smalltalk.StImage
	 * @category converting
	 */
	public StImage asImageAt_(int timeValue) {
		Image anImage = this.toImageAt_(timeValue);
		return (anImage == null) ? null : new StImage(anImage);
	}

	/**
	 * get the image from the movie.
	 * 
	 * @return java.awt.Image
	 * @category converting
	 */
	public Image toImage() {
		if (this.hasMovie() == true) {
			return movie.getImageAt(this.timeValue(), this.originalExtent());
		}
		return null;
	}

	/**
	 * get the image from the movie at the given time value.
	 * 
	 * @param timeValue int
	 * @return java.awt.Image
	 * @category converting
	 */
	public Image toImageAt_(int timeValue) {
		if (this.hasMovie() == true) {
			return movie.getImageAt(timeValue, this.originalExtent());
		}
		return null;
	}

	/**
	 * get the sound data from the movie.
	 * 
	 * @param start int
	 * @param duration int
	 * @return byte[]
	 * @category converting
	 */
	public byte[] asSoundDataFrom_duration_(int start, int duration) {
		if (this.hasMovie() == true) {
			return movie.getSoundData(start, duration);
		}

		return null;
	}

	/**
	 * copy the selected portions of the movie.
	 * 
	 * @return jp.co.sra.qt4jun.JunQTMovie
	 * @category copying
	 */
	public JunQTMovie copyMovie() {
		if (this.hasMovie() == true) {
			return movie.copySelection();
		}

		return null;
	}

	/**
	 * do movie task.
	 * 
	 * @category playing
	 */
	public void doMovieTask() {
		if (this.hasMovie() == true) {
			movie.task();
		}
	}

	/**
	 * Is the movie done or not?
	 * 
	 * @return boolean
	 * @category playing
	 */
	public boolean done() {
		if (this.hasMovie() == true) {
			return movie.isDone();
		}

		return true;
	}

	/**
	 * get the duration.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int duration() {
		if (this.hasMovie() == true) {
			int duration = movie.getDuration();
			if (duration > 0) {
				return duration;
			}
		}

		return 1;
	}

	/**
	 * get the duration in seconds.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double durationInSeconds() {
		return (double) this.duration() / this.timeScale();
	}

	/**
	 * get the filename.
	 * 
	 * @return java.io.File
	 * @category accessing
	 */
	public File filename() {
		return filename;
	}

	/**
	 * go to start of the movie.
	 * 
	 * @category playing
	 */
	public void goToBeginning() {
		if (this.hasMovie() == true) {
			movie.goToBeginning();
		}
	}

	/**
	 * go to end of the movie.
	 * 
	 * @category playing
	 */
	public void goToEnd() {
		if (this.hasMovie() == true) {
			movie.goToEnd();
		}
	}

	/**
	 * Has movie or not?
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasMovie() {
		if (movie == null) {
			this.recoverMovie();
		}

		return movie != null;
	}

	/**
	 * is movie a sound?
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isSound() {
		if (this.hasMovie() == true) {
			Rectangle box = movie.getBox();
			if ((box.width == 0) && (box.height == 0)) {
				return true;
			}
		}

		return false;
	}

	/**
	 * get the box of the movie.
	 * 
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public Rectangle movieBox() {
		if (this.hasMovie() == true) {
			Rectangle box = movie.getBox();
			if ((box.width == 0) && (box.height == 0)) {
				box.setSize(this.minimumSize());
			}
			return box;
		}

		return new Rectangle(0, 0, 1, 1);
	}

	/**
	 * set the box of the movie.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @deprecated since Jun500
	 * @category accessing
	 */
	public void movieBox_(Rectangle aRectangle) {
		if (this.hasMovie() == true) {
			movie.setBox(aRectangle);
		}
	}

	/**
	 * set the box of the movie.
	 * 
	 * @param port jp.co.sra.qt4jun.JunQTPort
	 * @param box java.awt.Rectangle
	 * @param offset java.awt.Point
	 * @category accessing
	 */
	public void movieBox_(JunQTPort port, Rectangle box, Point offset) {
		if (this.hasMovie() == true) {
			port.setMovieBox(movie, box, offset);
		}
	}

	/**
	 * get the next interesting time of the movie.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int nextInterestingTime() {
		if (this.hasMovie() == true) {
			int time = this.timeValue();
			int nextTime = movie.getNextInterestingTime(time, 1);
			if (nextTime < time) {
				return this.duration();
			} else {
				return nextTime;
			}
		} else {
			return 0;
		}
	}

	/**
	 * get the original extent of the movie.
	 * 
	 * @return java.awt.Dimension
	 * @category accessing
	 */
	public Dimension originalExtent() {
		return originalExtent;
	}

	/**
	 * get the previous interesting time of the movie.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int previousInterestingTime() {
		if (this.hasMovie() == true) {
			int time = this.timeValue();
			int nextTime = movie.getNextInterestingTime(time, -1);
			if (nextTime >= time) {
				return 0;
			} else {
				return nextTime;
			}
		} else {
			return 0;
		}
	}

	/**
	 * releasing.
	 * 
	 * @category initialize-release
	 */
	public void release() {
		this.releaseMovie();
		super.release();
	}

	/**
	 * release the movie.
	 * 
	 * @category initialize-release
	 */
	public void releaseMovie() {
		if (movie != null) {
			this.changed_($("releasing"));
			movie.release();
			movie = null;
		}

		dontRecover = true;
	}

	/**
	 * select portions of the movie.
	 * 
	 * @param selectionTime int
	 * @param selectionDuration int
	 * @category accessing
	 */
	public void selection_duration_(int selectionTime, int selectionDuration) {
		if (this.hasMovie() == true) {
			movie.setSelection(selectionTime, selectionDuration);
		}
	}

	/**
	 * start the movie.
	 * 
	 * @category playing
	 */
	public void start() {
		if (this.hasMovie() == true) {
			movie.start();
		}
	}

	/**
	 * stop the movie.
	 * 
	 * @category playing
	 */
	public void stop() {
		if (this.hasMovie() == true) {
			movie.stop();
		}
	}

	/**
	 * get the time scale.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int timeScale() {
		if (this.hasMovie() == true) {
			return movie.getTimeScale();
		}

		return 600;
	}

	/**
	 * get the time value.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int timeValue() {
		if (this.hasMovie() == true) {
			return movie.getTimeValue();
		}

		return 0;
	}

	/**
	 * set the time value.
	 * 
	 * @param aTimeValue int
	 * @category accessing
	 */
	public void timeValue_(int aTimeValue) {
		if (this.hasMovie() == true) {
			movie.setTimeValue(aTimeValue);
		}
	}

	/**
	 * get the time value in seconds.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double timeValueInSeconds() {
		return (double) this.timeValue() / this.timeScale();
	}

	/**
	 * set the time value in seconds.
	 * 
	 * @param aTimeValue double
	 * @category accessing
	 */
	public void timeValueInSeconds_(double aTimeValue) {
		this.timeValue_((int) (aTimeValue * this.timeScale()));
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @return a string representation of this <code>JunMoviePlayer</code>
	 *         object,  including the values of its member fields.
	 * @category printing
	 */
	public String toString() {
		String aString = new String();
		aString += this.getClass().getName();
		aString += "\n";
		aString += "\t";
		aString += "(";
		aString += "\n";
		aString += "\t";
		aString += ("filename: " + this.filename);
		aString += "\n\t";
		aString += ("movie: " + this.movie);
		aString += "\n\t";
		aString += ("originalExtent: " + this.originalExtent);
		aString += "\n\t";
		aString += ("dontRecover: " + this.dontRecover);
		aString += "\n";
		aString += ")";

		return aString;
	}

	/**
	 * update the movie.
	 * 
	 * @category playing
	 */
	public void updateMovie() {
		if (this.hasMovie() == true) {
			movie.update();
		}
	}

	/**
	 * get the volume.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double volume() {
		if (this.hasMovie() == true) {
			return movie.getVolume();
		}

		return 0;
	}

	/**
	 * set the volume.
	 * 
	 * @param volume double
	 * @category accessing
	 */
	public void volume_(double volume) {
		if (this.hasMovie() == true) {
			movie.setVolume(volume);
		}
	}

	/**
	 * private.     set the filename.
	 * 
	 * @param aFilename java.io.File
	 * @category private
	 */
	protected void setFilename_(File aFilename) {
		filename = aFilename;
	}

	/**
	 * private.     set the movie.
	 * 
	 * @param aMovie jp.co.sra.qt4jun.JunQTMovie
	 * @category private
	 */
	protected void setMovie_(JunQTMovie aMovie) {
		movie = aMovie;

		if (movie != null) {
			originalExtent = this.movieBox().getSize();
		}
	}

	/**
	 * enableRecover.
	 * 
	 * @category private
	 */
	protected void enableRecover() {
		dontRecover = false;
	}

	/**
	 * finalize.
	 * 
	 * @category initialize-release
	 */
	protected void finalize() {
		this.release();
	}

	/**
	 * minimumSize.
	 * 
	 * @return java.awt.Dimension
	 * @category private
	 */
	protected Dimension minimumSize() {
		return new Dimension(160, 12);
	}

	/**
	 * set the movie port.
	 * 
	 * @param port jp.co.sra.qt4jun.JunQTPort
	 * @category private
	 */
	public void moviePort_(JunQTPort port) {
		if (this.hasMovie() == true) {
			movie.setPort(port);
		}
	}

	/**
	 * Ask movie file and open it.
	 * 
	 * @category private
	 */
	protected void openMovie() {
		File aFilename = null;

		if (JunQTMovieFactory.canGetMovieFile()) {
			String theFilename = JunQTMovieFactory.getMovieFile();

			if (theFilename != null && theFilename.length() > 0) {
				aFilename = new File(theFilename);
			}
		} else {
			JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] { new JunFileModel.FileType($String("Movie files"), JunSystem.DefaultMovieExtensionPatterns()), JunFileModel.FileType.All($String("All files")) };
			aFilename = JunFileRequesterDialog.RequestFile($String("Select a <1p> file.", null, $String("Movie")), fileTypes, fileTypes[0]);
		}

		if (aFilename != null) {
			this.setFilename_(aFilename);
			this.setMovie_(JunQTMovieFactory.openMovie(filename));
		}
	}

	/**
	 * recover the movie.
	 * 
	 * @category private
	 */
	protected void recoverMovie() {
		if ((filename == null) || (dontRecover == true)) {
			return;
		}

		if (filename.exists()) {
			this.setMovie_(JunQTMovieFactory.openMovie(filename));
		}

		if (movie != null) {
			this.changed_($("recovered"));
		} else {
			dontRecover = true;
		}
	}
}
