package jp.co.sra.jun.goodies.movie.framework;

import java.awt.Cursor;
import java.awt.Point;
import java.io.File;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunMoviePlayerTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2001/01/24 (by NISHIHARA Satoshi)
 *  @updated   2002/11/14 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMoviePlayerTestExamples.java,v 8.11 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMoviePlayerTestExamples extends JunTestExamples {

	/**
	 * Create a new instance of JunMoviePlayer and just open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		(new JunMoviePlayer()).open();

		return true;
	}

	/**
	 * Example1: Create a new instance of JunMoviePlayer, ask to choose a movie file, and open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunMoviePlayer.OpenMovie();

		return true;
	}

	/**
	 * Example2: Create a new instance of JunMoviePlayer, ask to choose a movie file, and open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				new JunFileModel.FileType(JunSystem.$String("Movie files", null, JunSystem.$String("Movie")), JunSystem.DefaultMovieExtensionPatterns()),
				new JunFileModel.FileType(JunSystem.$String("Sound files", null, JunSystem.$String("Sound")), JunSystem.DefaultSoundExtensionPatterns()),
				new JunFileModel.FileType(JunSystem.$String("Image files", null, JunSystem.$String("Image")), JunSystem.DefaultImageExtensionPatterns()),
				JunFileModel.FileType.All(JunSystem.$String("All files")) };
		File aFile = JunFileRequesterDialog.Request(JunSystem.$String("Select a file."), fileTypes, fileTypes[0]);
		if (aFile == null) {
			return false;
		}

		JunMoviePlayer aMoviePlayer = new JunMoviePlayer(aFile);
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.open();

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				new JunFileModel.FileType(JunSystem.$String("Movie files", null, JunSystem.$String("Movie")), JunSystem.DefaultMovieExtensionPatterns()),
				new JunFileModel.FileType(JunSystem.$String("Sound files", null, JunSystem.$String("Sound")), JunSystem.DefaultSoundExtensionPatterns()),
				new JunFileModel.FileType(JunSystem.$String("Image files", null, JunSystem.$String("Image")), JunSystem.DefaultImageExtensionPatterns()),
				JunFileModel.FileType.All(JunSystem.$String("All files")) };
		File aFile = JunFileRequesterDialog.Request(JunSystem.$String("Select a file."), fileTypes, fileTypes[0]);
		if (aFile == null) {
			return false;
		}

		JunMoviePlayer aMoviePlayer = new JunMoviePlayer(aFile);
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.open();

		JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
		try {
			cursor._show();

			double nth = 0;
			double step = 0.1;
			int sign = 1;
			while (JunSensorUtility.NoButtonPressed()) {
				JunControlUtility.WaitForMilliseconds_(100);
				aMoviePlayer.goto_(nth);
				if (nth >= 1) {
					sign = -1;
				} else if (nth <= 0) {
					sign = 1;
				}
				nth += step * sign;
			}

		} finally {
			cursor._restore();
		}

		return true;
	}

	/**
	 * Example4: Open a movie, go to the specified frame, and spawn the frame as an image.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.open();
		for (double i = 0; i <= 1.0; i += 0.25) {
			aMoviePlayer.goto_(i);
			JunDisplayModel.OpenVisual_label_(aMoviePlayer.asImage(), "Display");
		}
		aMoviePlayer.prologue();

		return true;
	}

	/**
	 * Example5: Open a movie and play it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.openAndPlay();

		return true;
	}

	/**
	 * Example6: Open a movie, play it until the end, and close the player.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.goto_(0.9);
		aMoviePlayer.openAndPlayAndClose();

		return true;
	}

	/**
	 * Example7: Open a movie without a tracker, play it until the end, and close the player.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.goto_(0.9);
		aMoviePlayer.openAndPlayAndCloseWithoutTracker();

		return true;
	}

	/**
	 * Example8: Open a movie and play it by every 0.5 seconds.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.open();
		aMoviePlayer.prologue();
		while (aMoviePlayer.atEnd() == false) {
			aMoviePlayer.goInSeconds_(0.5);
		}

		return true;
	}

	/**
	 * Example9: Open a movie player with a tracker specified.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		aMoviePlayer.trackerModel().interval_(new double[] { 0.2, 0.8 });
		aMoviePlayer.trackerModel().fixFirstMarker_(true);
		// aMoviePlayer.trackerModel().fixLastMarker_(true);
		aMoviePlayer.open();

		return true;
	}

	/**
	 * ExampleA: Open three types of the movie player.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleA() {
		JunMoviePlayer aMoviePlayer = JunMoviePlayer.Request();
		if (aMoviePlayer == null) {
			return false;
		}

		JunMoviePlayer aMoviePlayerWithoutTracker = (JunMoviePlayer) aMoviePlayer.copy();
		aMoviePlayerWithoutTracker.openViewAt_(aMoviePlayerWithoutTracker.defaultViewWithoutTracker(), new Point(100, 200));
		aMoviePlayerWithoutTracker.normalSize();
		aMoviePlayerWithoutTracker.start();

		JunMoviePlayer aMoviePlayerWithTracker = (JunMoviePlayer) aMoviePlayer.copy();
		aMoviePlayerWithTracker.openViewAt_(aMoviePlayerWithTracker.defaultViewWithTracker(), new Point(250, 200));
		aMoviePlayerWithTracker.normalSize();
		aMoviePlayerWithTracker.start();

		JunMoviePlayer aMoviePlayerWithDoubleTracker = (JunMoviePlayer) aMoviePlayer.copy();
		aMoviePlayerWithDoubleTracker.openViewAt_(aMoviePlayerWithDoubleTracker.defaultViewWithDoubleTracker(), new Point(400, 200));
		aMoviePlayerWithDoubleTracker.normalSize();
		aMoviePlayerWithDoubleTracker.start();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunMoviePlayerTestExamples();
	}

}
