package jp.co.sra.jun.goodies.movie.support;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunMovieThumbnailsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/02/13 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun574 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMovieThumbnailsTestExamples.java,v 8.11 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMovieThumbnailsTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunMovieThumbnails movieThumbnails = JunMovieThumbnails.Request();
		if (movieThumbnails == null) {
			return false;
		}

		movieThumbnails.show();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunMovieThumbnails movieThumbnails = JunMovieThumbnails.Request();
		if (movieThumbnails == null) {
			return false;
		}

		movieThumbnails.tickMilliseconds_(250);
		movieThumbnails.thumbnailSize_(32);
		movieThumbnails.show();

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunMovieThumbnails movieThumbnails = JunMovieThumbnails.Request();
		if (movieThumbnails == null) {
			return false;
		}

		movieThumbnails.numberOfThumbnails_(100);
		movieThumbnails.thumbnailSize_(32);
		movieThumbnails.numberOfColumns_(20);
		movieThumbnails.show();

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunMovieThumbnails movieThumbnails = JunMovieThumbnails.Request();
		if (movieThumbnails == null) {
			return false;
		}

		movieThumbnails.numberOfThumbnails_(49);
		movieThumbnails.thumbnailSize_(72);
		movieThumbnails.numberOfColumns_(7);
		movieThumbnails.timeStamp_(true);
		movieThumbnails.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunMovieThumbnailsTestExamples();
	}

}
