package jp.co.sra.jun.goodies.multimedia;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;

import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.goodies.utilities.JunFileUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;

/**
 * JunMultiMediaBodyModel class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/03/14 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun646 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaBodyModel.java,v 8.7 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaBodyModel extends JunOpenGLDisplayModel implements JunMultiMediaViewable {
	protected String instVarName1;
	protected String instVarName2;
	protected transient StPopupMenu _popupMenu;

	/**
	 * Create a new instance of <code>JunMultiMediaBodyModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunMultiMediaBodyModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunMultiMediaBodyModel</code> and initialize it.
	 * 
	 * @param anOpenGL3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Instance creation
	 */
	public JunMultiMediaBodyModel(File aFile) {
		super();
		if (aFile.exists() && aFile.isFile() && aFile.canRead()) {
			StReadStream aStream = null;
			try {
				aStream = new StReadStream(aFile);
				String aString = JunFileUtility.ExtensionStringOf_(aFile).toLowerCase();
				if (aString.equals("lst")) {
					this.displayObject_(this.loadFromLST10_(aStream));
				}
				if (aString.equals("wrl")) {
					this.loadFromWRL97_(aStream);
				}
			} catch (IOException e) {
				throw new IllegalArgumentException(aFile.getPath() + " can not read.");
			} finally {
				if (aStream != null) {
					aStream.close();
				}
			}
		}
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialze() {
		super.initialize();
		instVarName1 = null;
		instVarName2 = null;
	}

	/**
	 * Make be invisible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beInvisible()
	 * @category accessing
	 */
	public void beInvisible() {
		this.beVisible(false);
	}

	/**
	 * Make be invisible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beInvisible()
	 * @category accessing
	 */
	public void beVisible() {
		this.beVisible(true);
	}

	/**
	 * Set the visibility.
	 * 
	 * @param beVisible boolean
	 * @category accessing
	 */
	protected void beVisible(boolean beVisible) {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaBodyView) {
				((JunMultiMediaBodyView) dependents[i]).toComponent().setVisible(beVisible);
			}
		}
	}

	/**
	 * Answer the receiver's body view.
	 * 
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyView
	 * @category interface opening
	 */
	public JunMultiMediaBodyView bodyView() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaBodyView) {
				return (JunMultiMediaBodyView) dependents[i];
			}
		}

		return null;
	}

	/**
	 * Create a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunMultiMediaBodyViewAwt(this);
		} else {
			return new JunMultiMediaBodyViewSwing(this);
		}
	}

	/**
	 * Answer this window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Body");
	}

	/**
	 * Answer true if a view of the image model is embedded, otherwise false.
	 *
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#isEmbedded()
	 * @category testing
	 */
	public boolean isEmbedded() {
		return this.builder().windows().length == 0;
	}

	/**
	 * Answer the receiver's popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		StPopupMenu aPopupMenu = new StPopupMenu();
		aPopupMenu.addAll(this._menuBar().menus());
		StMenuItem anItem = aPopupMenu.atNameKey_($("fileMenu"));
		if (anItem != null) {
			anItem.disable();
		}
		return aPopupMenu;
	}

	/**
	 * Set the size for the view.
	 * 
	 * @param extent java.awt.Dimension
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#setSize_(java.awt.Dimension)
	 * @category private
	 */
	protected void setSize_(Dimension extent) {
		if (this.isEmbedded()) {
			return;
		}

		super.setSize_(extent);
	}
}
