package jp.co.sra.jun.goodies.multimedia;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;

import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMultiMediaImageModel class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaImageModel.java,v 8.11 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaImageModel extends JunDisplayModel implements JunMultiMediaViewable {

	/**
	 * Create a new instance of <code>JunMultiMediaImageModel</code>.
	 * 
	 * @category Instance creation
	 */
	public JunMultiMediaImageModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunMultiMediaImageModel</code> and initialize it.
	 *
	 * @param aFile java.io.File
	 * @category Instance creation
	 */
	public JunMultiMediaImageModel(File aFile) {
		Object aVisual;
		if (aFile.exists()) {
			JunMoviePlayer aMoviePlayer = new JunMoviePlayer(aFile);
			try {
				if (aMoviePlayer.hasMovie()) {
					aVisual = aMoviePlayer.asImage();
				} else {
					aVisual = new StComposedText("Unexpected image file");
				}
			} finally {
				aMoviePlayer.release();
			}
		} else {
			aVisual = new StComposedText("Unexpected image file");
		}

		this.visual_(aVisual);
	}

	/**
	 * Make be invisible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beInvisible()
	 * @category accessing
	 */
	public void beInvisible() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaImageView) {
				((JunMultiMediaImageView) dependents[i]).toComponent().setVisible(false);
			}
		}
	}

	/**
	 * Make be visible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beVisible()
	 * @category accessing
	 */
	public void beVisible() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaImageView) {
				((JunMultiMediaImageView) dependents[i]).toComponent().setVisible(true);
			}
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public jp.co.sra.smalltalk.StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunMultiMediaImageViewAwt(this);
		} else {
			return new JunMultiMediaImageViewSwing(this);
		}
	}

	/**
	 * Answer true if the imag model is embedded, otherwise false.
	 *
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmbedded() {
		StView aView = this.getView();
		if (aView != null && aView.toComponent().getParent() instanceof Window) {
			return false;
		}

		return true;
	}

	/**
	 * Menu messages: Spawn the image.
	 * 
	 * @category menu messages
	 */
	public void spawnImage() {
		try {
			JunMultiMediaImageModel imageModel = (JunMultiMediaImageModel) this.getClass().newInstance();
			imageModel.visual_(this.visual());
			StView aView = this.getView();
			if (aView == null) {
				imageModel.open();
			} else {
				Point location = aView.toComponent().getLocationOnScreen();
				Point offsetPoint = this.defaultOffsetPoint();
				location.translate(offsetPoint.x, offsetPoint.y);
				imageModel.openViewAt_(imageModel.defaultView(), location);
			}
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		}
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			StPopupMenu aPopupMenu = new StPopupMenu();
			aPopupMenu.add(new StMenuItem(JunSystem.$String("Spawn"), new MenuPerformer(this, "spawnImage")));
			_popupMenu = aPopupMenu;
		}
		return _popupMenu;
	}

	/**
	 * Set the size for the view.
	 * 
	 * @param extent java.awt.Dimension
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#setSize_(java.awt.Dimension)
	 * @category bounds accessing
	 */
	protected void setSize_(Dimension extent) {
		if (this.isEmbedded()) {
			return;
		}

		super.setSize_(extent);
	}

	/**
	 * Process the change of my visual object.
	 * 
	 * @see jp.co.sra.jun.goodies.display.JunDisplayModel#visualIsChanged()
	 * @category private
	 */
	protected void visualIsChanged() {
		this.changed_($("visual"));
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Image");
	}
}
