package jp.co.sra.jun.goodies.nib;

import java.awt.Color;
import java.io.StringWriter;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunNibChoiceTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/19 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun538 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceTestExamples.java,v 8.11 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceTestExamples extends JunTestExamples {

	/**
	 * Example1: open nib choice window
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunNibChoice nibChoice = new JunNibChoice();
		nibChoice.compute_(new StBlockClosure() {
			public Object value_(Object anObject) {
				Object[] anArray = (Object[]) anObject;
				double[] nibCollection = (double[]) anArray[0];
				Double nibWidth = (Double) anArray[1];
				Color nibColor = (Color) anArray[2];
				StSymbol nibShape = (StSymbol) anArray[3];
				StringWriter writer = new StringWriter();
				for (int i = 0; i < nibCollection.length; i++) {
					if (i == 0) {
						writer.write("(");
					} else {
						writer.write(" ");
					}
					writer.write(String.valueOf(nibCollection[i]));
				}
				writer.write(") ");
				writer.write(nibWidth.toString());
				writer.write(" ");
				writer.write("(r=");
				writer.write(String.valueOf(nibColor.getRed()));
				writer.write(",g=");
				writer.write(String.valueOf(nibColor.getGreen()));
				writer.write(",b=");
				writer.write(String.valueOf(nibColor.getBlue()));
				writer.write(",a=");
				writer.write(String.valueOf(nibColor.getAlpha()));
				writer.write(") ");
				writer.write(nibShape.toString());
				System.out.println(writer.toString());

				return null;
			}
		});
		nibChoice.open();
		return true;
	}

	/**
	 * Example2: open nib choice window
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunNibChoice nibChoice = new JunNibChoice(new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 });
		nibChoice.open();
		return true;
	}

	/**
	 * Example3: open nib choice window
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunNibChoice nibChoice = new JunNibChoice(new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 }, 13.0f, Color.red, $("circle"));
		nibChoice.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunNibChoiceTestExamples();
	}

}
