package jp.co.sra.jun.goodies.nib;

import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunNibChoiceView interface
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/19 (By Nobuto Matsubara)
 *  @updated   2004/09/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceView.java,v 8.10 2008/02/20 06:31:51 nisinaka Exp $
 */
public interface JunNibChoiceView extends JunAbstractView {

	/**
	 * Answer my model as JunNibChoice.
	 * 
	 * @return jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @category model accessing
	 */
	public JunNibChoice getNibChoice();

	/**
	 * Answer the area of nib shape.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle nibShapeArea();

	/**
	 * Answer the area of nib width.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle nibWidthArea();

	/**
	 * Answer the string of nib width.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public String nibWidthString();

}
