package jp.co.sra.jun.goodies.nib;

import java.awt.Color;

import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

/**
 * JunNibChoiceWithColorTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/26 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun538 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceWithColorTestExamples.java,v 8.11 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceWithColorTestExamples extends JunTestExamples {

	/**
	 * Example1: open nib and color choice
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunNibChoiceWithColor nibChoice = new JunNibChoiceWithColor();
		nibChoice.compute_(new StBlockClosure() {
			public Object value_(Object anObject) {
				System.out.println(((Double) ((Object[]) anObject)[1]).doubleValue());
				return Boolean.TRUE;
			}
		});
		nibChoice.open();
		return true;
	}

	/**
	 * Example2: open nib and color choice
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		double[] nibCollection = new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 };
		JunNibChoiceWithColor nibChoice = new JunNibChoiceWithColor();
		nibChoice.nibCollection_(nibCollection);
		nibChoice.open();
		return true;
	}

	/**
	 * Example3: open nib and color choice
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		double[] nibCollection = new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 };
		double nibWidth = 13;
		Color nibColor = Color.red;
		StSymbol nibShape = $("circle");
		JunNibChoiceWithColor nibChoice = new JunNibChoiceWithColor();
		nibChoice.nibCollection_(nibCollection);
		nibChoice.nibWidth_(nibWidth);
		nibChoice.nibColor_(nibColor);
		nibChoice.nibShape_(nibShape);
		nibChoice.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunNibChoiceWithColorTestExamples();
	}
}
